/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.actions.models;

import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import metaanalysis.core.functionsapi.AbstractApplicationAction;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ModeratorValueMovedEvent;
import metaanalysis.core.persistence.Moderatorlevel;
import metaanalysis.core.persistence.ModeratorlevelId;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.NbBundle;

public class MoveModeratorValueToStudyAA
extends AbstractApplicationAction {
    private List<Moderatorvalue> moderatorValuesDaEliminare;
    private Moderatorvalue moderatorvalueIniziale;
    private Moderatorvalue moderatorvalueFinale;
    private Moderatorlevel moderatorLevel;
    private int livelloIniziale;

    public MoveModeratorValueToStudyAA(Moderatorvalue moderatorvalue, IApplicationManager applicationEventWorker) {
        super(NbBundle.getMessage(MoveModeratorValueToStudyAA.class, (String)"AA.UpdateModeratorValueAA.name"), applicationEventWorker);
        this.moderatorvalueIniziale = moderatorvalue;
        this.moderatorvalueFinale = this.moderatorvalueIniziale.duplicate();
        this.moderatorvalueFinale.getId().setLongidgenId(this.moderatorvalueFinale.getId().getStudyId());
        this.moderatorLevel = applicationEventWorker.getIDataFunction().getModeratorlevel(new ModeratorlevelId(moderatorvalue.getId().getModeratorId(), moderatorvalue.getId().getStudyId()));
        this.livelloIniziale = this.moderatorLevel.getModeratorlevel();
        if (this.moderatorLevel.getModeratorlevel() == Moderatorlevel.studyLevel) {
            this.setReady(false);
        }
        this.moderatorValuesDaEliminare = applicationEventWorker.getIDataFunction().getAllModeratorValuesOfStudy(this.moderatorvalueIniziale.getId().getStudyId(), this.moderatorvalueIniziale.getId().getModeratorId());
        this.setApplicationEventsAllInOne((IApplicationEvent)new ModeratorValueMovedEvent(this.moderatorvalueIniziale));
    }

    public void runImplementation() {
        this.getLowLevelFunctions().saveModeratorvalue(this.moderatorvalueFinale);
        for (Moderatorvalue mv : this.moderatorValuesDaEliminare) {
            this.getLowLevelFunctions().removeModeratorValue(mv);
        }
        this.moderatorLevel.setModeratorlevel(Integer.valueOf(Moderatorlevel.studyLevel));
        this.getLowLevelFunctions().saveModeratorlevel(this.moderatorLevel);
    }

    public void redoImplementation() throws CannotRedoException {
        this.runImplementation();
    }

    public void undoImplementation() throws CannotUndoException {
        for (Moderatorvalue mv : this.moderatorValuesDaEliminare) {
            this.getLowLevelFunctions().saveModeratorvalue(mv);
        }
        this.getLowLevelFunctions().removeModeratorValue(this.moderatorvalueFinale);
        this.moderatorLevel.setModeratorlevel(Integer.valueOf(this.livelloIniziale));
        this.getLowLevelFunctions().saveModeratorlevel(this.moderatorLevel);
    }
}

