/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.actions.models;

import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import metaanalysis.core.functionsapi.AbstractApplicationAction;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ModeratorDeletedEvent;
import metaanalysis.core.functionsapi.events.ModeratorResurrectionEvent;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorlevel;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.NbBundle;

public class RemoveModeratorAA
extends AbstractApplicationAction {
    private final Moderator moderator;
    private final List<Moderatorvalue> moderatorValuesToRemove;
    private final List<Moderatorlevel> moderatorlevelsToRemove;

    public RemoveModeratorAA(Moderator moderator, IApplicationManager applicationEventWorker) {
        super(NbBundle.getMessage(RemoveModeratorAA.class, (String)"AA.RemoveModeratorAA.name"), applicationEventWorker);
        this.moderator = moderator;
        this.moderatorValuesToRemove = this.getLowLevelFunctions().getAllModeratorValuesOfModerator(this.moderator);
        this.moderatorlevelsToRemove = this.getLowLevelFunctions().getAllModeratorLevelsOfModerator(moderator.getId());
    }

    public void runImplementation() {
        for (Moderatorlevel ml : this.moderatorlevelsToRemove) {
            this.getLowLevelFunctions().removeModeratorlevel(ml);
        }
        for (Moderatorvalue tmp : this.moderatorValuesToRemove) {
            this.getLowLevelFunctions().removeModeratorValue(tmp);
        }
        this.getLowLevelFunctions().removeModerator(this.moderator);
        this.launch((IApplicationEvent)new ModeratorDeletedEvent(this.moderator));
    }

    public void redoImplementation() throws CannotRedoException {
        this.runImplementation();
    }

    public void undoImplementation() throws CannotUndoException {
        this.getLowLevelFunctions().saveModerator(this.moderator);
        for (Moderatorlevel ml : this.moderatorlevelsToRemove) {
            this.getLowLevelFunctions().saveModeratorlevel(ml);
        }
        for (Moderatorvalue tmp : this.moderatorValuesToRemove) {
            this.getLowLevelFunctions().saveModeratorvalue(tmp);
        }
        this.launch((IApplicationEvent)new ModeratorResurrectionEvent(this.moderator));
    }
}

