/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.actions.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import metaanalysis.core.functionsapi.AbstractApplicationAction;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.OutcomebranchDeletedEvent;
import metaanalysis.core.functionsapi.events.OutcomebranchResurrectionEvent;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.NbBundle;

public class RemoveOutcomebranchAA
extends AbstractApplicationAction {
    private final Outcomebranch outcomebranch;
    private List<Moderatorvalue> moderatorvalues = new ArrayList<Moderatorvalue>();

    public RemoveOutcomebranchAA(Outcomebranch outcomebranch, IApplicationManager applicationEventWorker) {
        super(NbBundle.getMessage(RemoveOutcomebranchAA.class, (String)"AA.RemoveOutcomebranchAA.name"), applicationEventWorker);
        this.outcomebranch = outcomebranch;
    }

    public void runImplementation() {
        for (Moderatorvalue tmp : this.getLowLevelFunctions().getAllModeratorValuesOfNode(this.outcomebranch.getId())) {
            this.moderatorvalues.add(tmp);
            this.getLowLevelFunctions().removeModeratorValue(tmp);
        }
        this.getLowLevelFunctions().removeOutcomebranch(this.outcomebranch);
        this.launch((IApplicationEvent)new OutcomebranchDeletedEvent(this.outcomebranch));
    }

    public void redoImplementation() throws CannotRedoException {
        for (Moderatorvalue tmp : this.moderatorvalues) {
            this.getLowLevelFunctions().removeModeratorValue(tmp);
        }
        this.getLowLevelFunctions().removeOutcomebranch(this.outcomebranch);
        this.launch((IApplicationEvent)new OutcomebranchDeletedEvent(this.outcomebranch));
    }

    public void undoImplementation() throws CannotUndoException {
        this.getLowLevelFunctions().saveOutcomebranch(this.outcomebranch);
        for (Moderatorvalue tmp : this.moderatorvalues) {
            this.getLowLevelFunctions().saveModeratorvalue(tmp);
        }
        this.launch((IApplicationEvent)new OutcomebranchResurrectionEvent(this.outcomebranch));
    }
}

