/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.actions.models;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import metaanalysis.core.functionsapi.AbstractApplicationAction;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ProjectDeletedEvent;
import metaanalysis.core.functionsapi.events.ProjectResurrectionEvent;
import metaanalysis.core.persistence.Project;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.NbBundle;

public class RemoveProjectAA
extends AbstractApplicationAction {
    private Project project;

    public RemoveProjectAA(Project project, IApplicationManager applicationEventWorker) {
        super(NbBundle.getMessage(RemoveProjectAA.class, (String)"AA.RemoveProjectAA.name"), applicationEventWorker);
        this.project = project;
        this.setRunApplicationEvent((IApplicationEvent)new ProjectDeletedEvent(this.project));
        this.setRedoApplicationEvent((IApplicationEvent)new ProjectDeletedEvent(this.project));
        this.setUndoApplicationEvent((IApplicationEvent)new ProjectResurrectionEvent(this.project));
    }

    public void runImplementation() {
        this.getLowLevelFunctions().removeProject(this.project);
    }

    public void redoImplementation() throws CannotRedoException {
        this.runImplementation();
    }

    public void undoImplementation() throws CannotUndoException {
        this.getLowLevelFunctions().saveProject(this.project);
    }
}

