/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.actions.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import metaanalysis.actions.models.RemoveSubgroupbranchAA;
import metaanalysis.core.functionsapi.AbstractApplicationAction;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.StudyDeletedEvent;
import metaanalysis.core.functionsapi.events.StudyResurrectionEvent;
import metaanalysis.core.persistence.Moderatorlevel;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Subgroupbranch;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.NbBundle;

public class RemoveStudyAA
extends AbstractApplicationAction {
    private final Study study;
    List<Moderatorlevel> moderatorlevels = new ArrayList<Moderatorlevel>();
    private List<Moderatorvalue> moderatorvalues = new ArrayList<Moderatorvalue>();

    public RemoveStudyAA(Study study, IApplicationManager applicationEventWorker) {
        super(NbBundle.getMessage(RemoveStudyAA.class, (String)"AA.RemoveStudyAA.name"), applicationEventWorker);
        this.study = study;
        this.moderatorlevels = this.getLowLevelFunctions().getAllModeratorLevelsOfStudy(study.getId());
        for (Subgroupbranch tmp : this.getLowLevelFunctions().getAllSubgroupbranchesOfStudy(study)) {
            this.addPreApplicationAction((IApplicationActionModel)new RemoveSubgroupbranchAA(tmp, this.getApplicationEventWorker()));
        }
        this.setRunApplicationEvent((IApplicationEvent)new StudyDeletedEvent(study));
        this.setUndoApplicationEvent((IApplicationEvent)new StudyResurrectionEvent(study));
        this.setRedoApplicationEvent((IApplicationEvent)new StudyDeletedEvent(study));
    }

    public void runImplementation() {
        for (Moderatorvalue tmp : this.getLowLevelFunctions().getAllModeratorValuesOfStudy(this.study.getId())) {
            this.moderatorvalues.add(tmp);
            this.getLowLevelFunctions().removeModeratorValue(tmp);
        }
        for (Moderatorlevel ml : this.moderatorlevels) {
            this.getLowLevelFunctions().removeModeratorlevel(ml);
        }
        this.getLowLevelFunctions().removeStudy(this.study);
    }

    public void redoImplementation() throws CannotRedoException {
        for (Moderatorvalue tmp : this.moderatorvalues) {
            this.getLowLevelFunctions().removeModeratorValue(tmp);
        }
        for (Moderatorlevel ml : this.moderatorlevels) {
            this.getLowLevelFunctions().removeModeratorlevel(ml);
        }
        this.getLowLevelFunctions().removeStudy(this.study);
    }

    public void undoImplementation() throws CannotUndoException {
        this.getLowLevelFunctions().saveStudy(this.study);
        for (Moderatorlevel ml : this.moderatorlevels) {
            this.getLowLevelFunctions().saveModeratorlevel(ml);
        }
        for (Moderatorvalue tmp : this.moderatorvalues) {
            this.getLowLevelFunctions().saveModeratorvalue(tmp);
        }
    }
}

