/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.actions.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import metaanalysis.actions.models.RemoveOutcomebranchAA;
import metaanalysis.core.functionsapi.AbstractApplicationAction;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.TimepointbranchDeletedEvent;
import metaanalysis.core.functionsapi.events.TimepointbranchResurrectionEvent;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.core.persistence.Timepointbranch;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.NbBundle;

public class RemoveTimepointbranchAA
extends AbstractApplicationAction {
    protected final Timepointbranch timepointbranch;
    private List<Moderatorvalue> moderatorvalues = new ArrayList<Moderatorvalue>();

    public RemoveTimepointbranchAA(Timepointbranch timepointbranch, IApplicationManager applicationEventWorker) {
        super(NbBundle.getMessage(RemoveTimepointbranchAA.class, (String)"AA.RemoveTimepointbranchAA.name"), applicationEventWorker);
        this.timepointbranch = timepointbranch;
        for (Outcomebranch tmp : this.getLowLevelFunctions().getAllOutcomebranchsOfTimepointbranch(timepointbranch)) {
            RemoveOutcomebranchAA action = new RemoveOutcomebranchAA(tmp, this.getApplicationEventWorker());
            action.setSilent(true);
            this.addPreApplicationAction((IApplicationActionModel)action);
        }
    }

    public void runImplementation() {
        for (Moderatorvalue tmp : this.getLowLevelFunctions().getAllModeratorValuesOfNode(this.timepointbranch.getId())) {
            this.moderatorvalues.add(tmp);
            this.getLowLevelFunctions().removeModeratorValue(tmp);
        }
        this.getLowLevelFunctions().removeTimepointbranch(this.timepointbranch);
        this.launch((IApplicationEvent)new TimepointbranchDeletedEvent(this.timepointbranch));
    }

    public void redoImplementation() throws CannotRedoException {
        for (Moderatorvalue tmp : this.moderatorvalues) {
            this.getLowLevelFunctions().removeModeratorValue(tmp);
        }
        this.getLowLevelFunctions().removeTimepointbranch(this.timepointbranch);
        this.launch((IApplicationEvent)new TimepointbranchDeletedEvent(this.timepointbranch));
    }

    public void undoImplementation() throws CannotUndoException {
        this.getLowLevelFunctions().saveTimepointbranch(this.timepointbranch);
        for (Moderatorvalue tmp : this.moderatorvalues) {
            this.getLowLevelFunctions().saveModeratorvalue(tmp);
        }
        this.launch((IApplicationEvent)new TimepointbranchResurrectionEvent(this.timepointbranch));
    }
}

