/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.actions.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import metaanalysis.actions.models.ResetModeratorValueAA;
import metaanalysis.actions.models.UpdateModeratorrecodeAA;
import metaanalysis.core.functionsapi.AbstractApplicationAction;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ModeratorUpdatedEvent;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorrecode;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.Topic;
import metaanalysis.events.models.IApplicationEvent;
import metaanalysis.moderatorrecode.apis.AbstractCategoricalRole;
import metaanalysis.moderatorrecode.apis.IRecodeRole;
import metaanalysis.moderatorrecode.apis.ModeratorRecodeMachine;
import org.openide.util.NbBundle;

public class UpdateModeratorAA
extends AbstractApplicationAction {
    private final Moderator oldV;
    private final Moderator newV;
    private final Topic topic;
    List<ResetModeratorValueAA> azioni_di_reset = new ArrayList<ResetModeratorValueAA>();

    public UpdateModeratorAA(Moderator moderator, IApplicationManager applicationEventWorker) {
        super(NbBundle.getMessage(UpdateModeratorAA.class, (String)"AA.UpdateModeratorAA.name"), applicationEventWorker);
        this.oldV = this.getLowLevelFunctions().getModerator(moderator.getId());
        this.newV = moderator.duplicate();
        this.topic = this.getLowLevelFunctions().getTopic(this.oldV.getTopicId().longValue());
        if (moderator.getModeratortype() == Moderator.categoricalType) {
            List allModeratorrecodeOfModerator = this.getLowLevelFunctions().getAllModeratorrecodeOfModerator(moderator);
            for (Moderatorrecode mr : allModeratorrecodeOfModerator) {
                ModeratorRecodeMachine mrm = ModeratorRecodeMachine.toModeratorRecodingMachine((String)mr.getModeratorrecodingmachine());
                ArrayList roles = mrm.getRoles();
                for (IRecodeRole role : roles) {
                    if (!(role instanceof AbstractCategoricalRole)) continue;
                    ((AbstractCategoricalRole)role).filterMatchedValues(moderator.getDefvalues().split("\n"));
                }
                mr.setModeratorrecodingmachine(ModeratorRecodeMachine.toSerializedObject((ModeratorRecodeMachine)mrm));
                this.addPostApplicationAction((IApplicationActionModel)new UpdateModeratorrecodeAA(mr, applicationEventWorker));
            }
        }
        if (this.newV.getModeratortype() == Moderator.categoricalType) {
            List valori = this.getLowLevelFunctions().getAllModeratorValuesOfModerator(this.newV);
            for (Moderatorvalue mv : valori) {
                if (this.isValidCategoricalValue(mv.getCategoricalvalue(), this.newV)) continue;
                this.addPostApplicationAction((IApplicationActionModel)new ResetModeratorValueAA(mv, this.getApplicationEventWorker()));
            }
        }
    }

    public void runImplementation() {
        this.getLowLevelFunctions().updateModerator(this.newV);
        this.launch((IApplicationEvent)new ModeratorUpdatedEvent(this.newV));
    }

    public void redoImplementation() throws CannotRedoException {
        this.getLowLevelFunctions().updateModerator(this.newV);
        this.launch((IApplicationEvent)new ModeratorUpdatedEvent(this.newV));
    }

    public void undoImplementation() throws CannotUndoException {
        this.getLowLevelFunctions().updateModerator(this.oldV);
        this.launch((IApplicationEvent)new ModeratorUpdatedEvent(this.oldV));
    }

    public final boolean isValidCategoricalValue(String value, Moderator moderator) {
        String[] tmp;
        if (moderator.getDefvalues() == null || moderator.getDefvalues().equals("")) {
            return false;
        }
        if (value == null) {
            return true;
        }
        for (String x : tmp = moderator.getDefvalues().split("\n")) {
            if (!value.equals(x)) continue;
            return true;
        }
        return false;
    }
}

