/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.functionsapi;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.IDataFunctions;
import metaanalysis.events.models.IApplicationEvent;

public abstract class AbstractApplicationAction
extends AbstractUndoableEdit
implements IApplicationActionModel {
    protected final String actionName;
    private final IApplicationManager applicationEventWorker;
    private long actionTimeSign = new Date().getTime();
    protected List<IApplicationActionModel> preActions = new ArrayList<IApplicationActionModel>();
    protected List<IApplicationActionModel> postActions = new ArrayList<IApplicationActionModel>();
    private boolean reversible = true;
    private IApplicationEvent runApplicationEvent = null;
    private IApplicationEvent undoApplicationEvent = null;
    private IApplicationEvent redoApplicationEvent = null;
    protected boolean ready = true;
    protected boolean silent = false;

    public AbstractApplicationAction(String actionName, IApplicationManager applicationEventWorker, boolean silent) {
        this.actionName = actionName;
        this.applicationEventWorker = applicationEventWorker;
        this.silent = silent;
    }

    public AbstractApplicationAction(String actionName, IApplicationManager applicationEventWorker) {
        this.actionName = actionName;
        this.applicationEventWorker = applicationEventWorker;
    }

    public AbstractApplicationAction(String actionName) {
        this.actionName = actionName;
        this.applicationEventWorker = null;
    }

    public IApplicationEvent getRedoApplicationEvent() {
        return this.redoApplicationEvent;
    }

    public void setRedoApplicationEvent(IApplicationEvent redoApplicationEvent) {
        this.redoApplicationEvent = redoApplicationEvent;
    }

    public IApplicationEvent getRunApplicationEvent() {
        return this.runApplicationEvent;
    }

    public void setRunApplicationEvent(IApplicationEvent runApplicationEvent) {
        this.runApplicationEvent = runApplicationEvent;
    }

    public IApplicationEvent getUndoApplicationEvent() {
        return this.undoApplicationEvent;
    }

    public void setUndoApplicationEvent(IApplicationEvent undoApplicationEvent) {
        this.undoApplicationEvent = undoApplicationEvent;
    }

    public void setApplicationEventsAllInOne(IApplicationEvent event) {
        this.setRunApplicationEvent(event);
        this.setRedoApplicationEvent(event);
        this.setUndoApplicationEvent(event);
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    protected final IDataFunctions getLowLevelFunctions() {
        return this.applicationEventWorker.getIDataFunction();
    }

    protected final void launch(IApplicationEvent applicationEvent) {
        if (!this.silent && applicationEvent != null) {
            this.applicationEventWorker.setApplicationEvent(applicationEvent);
        }
    }

    protected final IApplicationManager getApplicationEventWorker() {
        return this.applicationEventWorker;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    @Override
    public boolean isReversible() {
        return this.reversible;
    }

    public void setReversible(boolean reversible) {
        this.reversible = reversible;
    }

    @Override
    public void runImplementation() {
    }

    @Override
    public String getPresentationName() {
        return this.actionName;
    }

    @Override
    public String getRedoPresentationName() {
        return this.actionName;
    }

    @Override
    public String getUndoPresentationName() {
        return this.actionName;
    }

    @Override
    public boolean canRedo() {
        return this.isReversible();
    }

    @Override
    public boolean canUndo() {
        return this.isReversible();
    }

    @Override
    public void addPreApplicationAction(IApplicationActionModel action) {
        this.preActions.add(action);
    }

    @Override
    public void addPostApplicationAction(IApplicationActionModel action) {
        this.postActions.add(action);
    }

    @Override
    public final void run() throws CannotRedoException {
        if (this.isReady()) {
            for (IApplicationActionModel action : this.preActions) {
                action.run();
            }
            this.runImplementation();
            for (IApplicationActionModel action : this.postActions) {
                action.run();
            }
            this.launch(this.runApplicationEvent);
        }
    }

    @Override
    public final void redo() throws CannotRedoException {
        if (this.isReady()) {
            for (IApplicationActionModel action : this.preActions) {
                action.redo();
            }
            this.redoImplementation();
            for (IApplicationActionModel action : this.postActions) {
                action.redo();
            }
            this.launch(this.redoApplicationEvent);
        }
    }

    @Override
    public final void undo() throws CannotUndoException {
        if (this.isReady()) {
            int i;
            for (i = this.postActions.size() - 1; i >= 0; --i) {
                this.postActions.get(i).undo();
            }
            this.undoImplementation();
            for (i = this.preActions.size() - 1; i >= 0; --i) {
                this.preActions.get(i).undo();
            }
            this.launch(this.undoApplicationEvent);
        }
    }

    @Override
    public void redoImplementation() {
    }

    @Override
    public void undoImplementation() {
    }

    @Override
    public long getActionTimeSign() {
        return this.actionTimeSign;
    }
}

