/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.functionsapi;

import java.util.Date;
import javax.swing.event.UndoableEditEvent;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import org.openide.awt.UndoRedo;

public class ApplicationActionHandler {
    private IApplicationActionModel lastAction;
    private long lastActionTime = 0L;
    private long timeBetweenActionTrigger;
    private UndoRedo.Manager manager;

    public ApplicationActionHandler(UndoRedo.Manager manager, long timeBetweenActionTrigger) {
        this.manager = manager;
        this.timeBetweenActionTrigger = timeBetweenActionTrigger;
    }

    public void runAction(IApplicationActionModel action) {
        if (action.isReady()) {
            action.run();
            this.addAction(action);
        }
    }

    public ApplicationActionHandler(UndoRedo.Manager manager) {
        this(manager, 2500L);
    }

    private void reset() {
        this.manager.discardAllEdits();
    }

    private void addAction(IApplicationActionModel action) {
        if (action.getActionTimeSign() - this.lastActionTime > this.timeBetweenActionTrigger) {
            if (action.isReversible()) {
                this.manager.undoableEditHappened(new UndoableEditEvent(action, action));
            } else {
                this.reset();
            }
        } else {
            this.lastAction.addPostApplicationAction(action);
        }
        this.lastAction = action;
        this.lastActionTime = new Date().getTime();
    }

    public UndoRedo.Manager getManager() {
        return this.manager;
    }
}

