/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.moderatorrecode.apis;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.moderatorrecode.apis.IRecodeRole;

public class ModeratorRecodeMachine
implements Serializable {
    protected ArrayList<IRecodeRole> roles = new ArrayList();

    public ArrayList<IRecodeRole> getRoles() {
        return this.roles;
    }

    public void setRoles(ArrayList<IRecodeRole> roles) {
        this.roles = roles;
    }

    public IRecodeRole match(String valueToRecode) {
        for (IRecodeRole x : this.getRoles()) {
            if (!x.match(valueToRecode)) continue;
            return x;
        }
        return null;
    }

    public IRecodeRole match(double valueToRecode) {
        IRecodeRole last = this.getRoles().get(0);
        for (IRecodeRole x : this.getRoles()) {
            if (!x.match(valueToRecode)) {
                return last;
            }
            last = x;
        }
        return null;
    }

    public String recode(String value) {
        if (value == null) {
            return null;
        }
        ArrayList<IRecodeRole> list = new ArrayList<IRecodeRole>();
        list.addAll(this.roles);
        Collections.reverse(list);
        for (IRecodeRole r : list) {
            if (!r.match(value)) continue;
            return r.getCodedValue();
        }
        return null;
    }

    public String recode(Integer value) {
        if (value != null) {
            return this.recode(new Double(value.intValue()));
        }
        return null;
    }

    public String recode(Double value) {
        if (value == null) {
            return null;
        }
        ArrayList<IRecodeRole> list = new ArrayList<IRecodeRole>();
        list.addAll(this.roles);
        Collections.reverse(list);
        for (IRecodeRole r : list) {
            if (!r.match(value)) continue;
            return r.getCodedValue();
        }
        return null;
    }

    public String recode(Moderatorvalue moderatorvalue) {
        Integer moderatortype = moderatorvalue.getModeratortype();
        if (moderatortype == Moderator.categoricalType) {
            return this.recode(moderatorvalue.getCategoricalvalue());
        }
        if (moderatortype == Moderator.continuousType) {
            return this.recode(moderatorvalue.getContinuousvalue());
        }
        return this.recode(moderatorvalue.getIntegervalue());
    }

    public static String toSerializedObject(ModeratorRecodeMachine rm) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEncoder xmlEncoder = new XMLEncoder(baos);
        xmlEncoder.writeObject(rm);
        xmlEncoder.close();
        return baos.toString();
    }

    public static ModeratorRecodeMachine toModeratorRecodingMachine(String rm) {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(rm.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(ModeratorRecodeMachine.class.getName()).log(Level.SEVERE, null, ex);
        }
        XMLDecoder d = new XMLDecoder(is);
        Object result = d.readObject();
        d.close();
        return (ModeratorRecodeMachine)result;
    }

    public static String[] transformMatchValuesFromStringToStringArray(String values) {
        return ModeratorRecodeMachine.split(ModeratorRecodeMachine.fixValues(values));
    }

    public static String transformMatchValuesFromStringArrayToString(String[] values) {
        return ModeratorRecodeMachine.fixValues(ModeratorRecodeMachine.join(values));
    }

    public static String fixValues(String values) {
        String correct = "";
        values.replaceAll("\n\n", "\n");
        Object[] splitted = ModeratorRecodeMachine.split(values);
        Arrays.sort(splitted);
        String acapo = "";
        Object lastString = "";
        for (Object tmp : splitted) {
            if (((String)tmp).equals(lastString)) continue;
            correct = correct + acapo + (String)tmp;
            acapo = "\n";
            lastString = tmp;
        }
        return correct;
    }

    public static String[] split(String values) {
        return values.split("\n");
    }

    public static String join(String[] values) {
        String correct = "";
        String acapo = "";
        for (String tmp : values) {
            correct = correct + acapo + tmp;
            acapo = "\n";
        }
        return correct;
    }
}

