/*
 * Decompiled with CFR 0.152.
 */
package metaanalsysis.guiutil.guicheckers;

import javax.swing.JTextArea;
import javax.swing.JTextField;
import metaanalsysis.guiutil.guicheckers.IGuiField;
import metaanalsysis.guiutil.guicheckers.JTextAreaGuiField;
import metaanalsysis.guiutil.guicheckers.JTextGuiField;
import metaanalysis.application.style.StyleProvider;
import org.openide.util.NbBundle;

public abstract class AbstractRole {
    public static int wrongContentState = 0;
    public static int rightContentState = 1;
    public static int correctContentState = 2;
    protected IGuiField source;
    private int state = -1;

    public AbstractRole(JTextField source) {
        this.source = new JTextGuiField(source);
    }

    public AbstractRole(JTextArea source) {
        this.source = new JTextAreaGuiField(source);
    }

    public AbstractRole(IGuiField iGuiField) {
        this.source = iGuiField;
    }

    public final String getStringValue() {
        return this.getSource().getText();
    }

    public void setValue(String value) {
        this.source.setText(value);
    }

    public IGuiField getSource() {
        return this.source;
    }

    protected abstract boolean isCorrect();

    protected abstract boolean tryToFix();

    public final void checkInTyping() {
        if (this.isCorrect()) {
            this.goToState(rightContentState);
        } else {
            this.goToState(wrongContentState);
        }
    }

    public Double getDoubleValue() {
        return null;
    }

    public Integer getIntegerValue() {
        return null;
    }

    public final boolean check(boolean fix) {
        String tmp = this.getStringValue();
        if (!this.isCorrect()) {
            if (fix && this.tryToFix()) {
                this.goToState(correctContentState);
                return true;
            }
            this.goToState(wrongContentState);
            return false;
        }
        if (!fix && this.state == correctContentState) {
            return true;
        }
        this.goToState(rightContentState);
        return true;
    }

    public abstract boolean controllaAggiustamentiDopoParsing();

    protected final void goToState(int newState) {
        this.state = newState;
        this.source.setToolTipText(this.getCorrectStateTooltip());
        this.refreshBackground();
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getCorrectStateTooltip() {
        if (this.state == correctContentState) {
            return NbBundle.getMessage(AbstractRole.class, (String)"correctedToolType.text");
        }
        if (this.state == rightContentState) {
            return NbBundle.getMessage(AbstractRole.class, (String)"rightToolType.text");
        }
        return NbBundle.getMessage(AbstractRole.class, (String)"wrongToolType.text");
    }

    private void refreshBackground() {
        if (this.getState() == rightContentState) {
            this.source.setBackground(StyleProvider.rightColor);
        } else if (this.getState() == wrongContentState) {
            this.source.setBackground(StyleProvider.wrongColor);
        } else if (this.getState() == correctContentState) {
            this.source.setBackground(StyleProvider.correctColor);
        }
    }
}

