/*
 * Decompiled with CFR 0.152.
 */
package metaanalsysis.guiutil.guicheckers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import metaanalsysis.guiutil.guicheckers.AbstractRole;
import metaanalsysis.guiutil.guicheckers.IGuiField;
import metaanalsysis.guiutil.guicheckers.JTextAreaGuiField;
import metaanalsysis.guiutil.guicheckers.JTextGuiField;
import metaanalsysis.guiutil.guicheckers.MyFocusListener;
import metaanalsysis.guiutil.guicheckers.MyKeyListener;
import org.openide.awt.UndoRedo;

public class GuiChecker {
    List<JComponent> eligibleObjects = new ArrayList<JComponent>();
    private Map<IGuiField, AbstractRole> textFields = new HashMap<IGuiField, AbstractRole>();
    private UndoRedo.Manager manager;
    private final boolean autoselectContentEnable;

    public Map<IGuiField, AbstractRole> getIGuiFields() {
        return this.textFields;
    }

    public GuiChecker(boolean autoselectContentEnable) {
        this.manager = null;
        this.autoselectContentEnable = autoselectContentEnable;
    }

    public GuiChecker(UndoRedo.Manager manager, boolean autoselectContentEnable) {
        this.manager = manager;
        this.autoselectContentEnable = autoselectContentEnable;
    }

    public List<JComponent> getEligibleObjects() {
        return this.eligibleObjects;
    }

    public void setEligibleObjects(List<JComponent> eligibleObjects) {
        this.eligibleObjects = eligibleObjects;
    }

    public boolean checkWhitoutFix() {
        return this.checkFields(false);
    }

    public boolean checkAndFix() {
        return this.checkFields(true);
    }

    public void fieldChange(IGuiField field) {
        this.getRole(field).checkInTyping();
        this.checkWhitoutFix();
    }

    public void fieldChange(JTextField field) {
        this.getRole(field).checkInTyping();
        this.checkWhitoutFix();
    }

    public void fieldChange(JTextArea field) {
        this.getRole(field).checkInTyping();
        this.checkWhitoutFix();
    }

    public void checkAndFixField(IGuiField field) {
        this.getRole(field).check(true);
    }

    public void checkAndFixField(JTextField field) {
        this.getRole(field).check(true);
    }

    public void checkAndFixField(JTextArea field) {
        this.getRole(field).check(true);
    }

    private boolean checkFields(boolean fix) {
        boolean ok = true;
        for (AbstractRole role : this.textFields.values()) {
            if (role.check(fix)) continue;
            ok = false;
        }
        if (!ok) {
            this.disableEligibleObjects(false);
        } else {
            this.enableEligibleObjects();
        }
        return ok;
    }

    public AbstractRole getRole(IGuiField field) {
        return this.textFields.get(field);
    }

    public AbstractRole getRole(JTextField field) {
        for (IGuiField f : this.textFields.keySet()) {
            JTextGuiField x;
            if (!(this.textFields.get(f).getSource() instanceof JTextGuiField) || (x = (JTextGuiField)this.textFields.get(f).getSource()).getField() != field) continue;
            return this.textFields.get(f);
        }
        return null;
    }

    public AbstractRole getRole(JTextArea field) {
        for (IGuiField f : this.textFields.keySet()) {
            JTextAreaGuiField x;
            if (!(this.textFields.get(f).getSource() instanceof JTextAreaGuiField) || (x = (JTextAreaGuiField)this.textFields.get(f).getSource()).getField() != field) continue;
            return this.textFields.get(f);
        }
        return null;
    }

    public void addRole(AbstractRole role) {
        this.addRole(role, true);
    }

    public void addRole(AbstractRole role, boolean listener) {
        this.textFields.put(role.getSource(), role);
        if (listener) {
            role.getSource().addKeyListener(new MyKeyListener(this, role, this.manager));
            role.getSource().addFocusListener(new MyFocusListener(this, role, this.autoselectContentEnable));
        }
        if (this.manager != null) {
            // empty if block
        }
    }

    public void removeRole(AbstractRole role) {
        role.getSource().removeAllListeners();
        this.textFields.remove(role.getSource());
    }

    public void svuota() {
        for (AbstractRole tmp : this.textFields.values()) {
            tmp.getSource().removeAllListeners();
        }
        this.textFields.clear();
        this.eligibleObjects.clear();
    }

    public void enableEligibleObjects() {
        for (JComponent c : this.getEligibleObjects()) {
            c.setEnabled(true);
            c.setVisible(true);
        }
    }

    public void disableEligibleObjects(boolean hide) {
        for (JComponent c : this.getEligibleObjects()) {
            c.setEnabled(false);
            if (hide) {
                c.setVisible(false);
                continue;
            }
            c.setVisible(true);
        }
    }
}

