/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.projects.guiandnodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.analysis.impl.PreAnalysisRunner;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.PreanalysisUpdatedEvent;
import metaanalysis.core.persistence.Preanalysis;
import metaanalysis.dataeditor.models.AbstractApplicationNode;
import metaanalysis.dataeditor.models.INodeEditor;
import metaanalysis.events.models.IUpdateEvent;
import metaanalysis.projects.guiandnodes.ProjectNode;
import metaanalysis.projects.guiandnodes.editors.PreAnalysisEditorPanel;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

public class PreanalysisNode
extends AbstractApplicationNode
implements INodeEditor,
PropertyChangeListener {
    private final Preanalysis preanalysis;

    public PreanalysisNode(Preanalysis preanalysis, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children, Lookups.singleton((Object)preanalysis));
        this.preanalysis = preanalysis;
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/pre_analysis_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/pre_analysis_iconOpen.png");
    }

    public boolean canDestroy() {
        return false;
    }

    public String getDisplayName() {
        return this.preanalysis.getName();
    }

    public Action[] getActions(boolean context) {
        return new Action[0];
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent") && pce.getNewValue() instanceof PreanalysisUpdatedEvent && ((PreanalysisUpdatedEvent)pce.getNewValue()).getPreanalysis().getId() == this.preanalysis.getId() && pce.getNewValue() instanceof IUpdateEvent) {
            this.preanalysis.copyFrom(((PreanalysisUpdatedEvent)pce.getNewValue()).getPreanalysis());
            this.setName(this.preanalysis.getName());
            this.setDisplayName(this.preanalysis.getName());
        }
    }

    public PreAnalysisEditorPanel getNodeEditor() {
        return new PreAnalysisEditorPanel(this.preanalysis.getId(), this.applicationEventWorker, new GuiChecker(this.applicationEventWorker.getEditorPanelsUndoRedoManager(), TuliTuliTools.isAutoSelectContentFieldEnabled()));
    }

    private class RunAnalysisAction
    extends AbstractAction
    implements Presenter.Popup {
        public RunAnalysisAction() {
            this.putValue("Name", NbBundle.getMessage(ProjectNode.class, (String)"ProjectNode.RunAnalysisAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreAnalysisRunner p = new PreAnalysisRunner(PreanalysisNode.this.applicationEventWorker, PreanalysisNode.this.preanalysis);
            p.start();
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/run_analysis_icon.png")));
            return x;
        }
    }
}

