/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.projects.guiandnodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalysis.actions.models.CloneProjectAA;
import metaanalysis.actions.models.RemoveProjectAA;
import metaanalysis.analysis.models.events.ProjectAnalysisDoneEvent;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.analysis.impl.ProjectAnalysisRunner;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ProjectEvents;
import metaanalysis.core.persistence.Project;
import metaanalysis.dataeditor.models.AbstractApplicationNode;
import metaanalysis.dataeditor.models.INodeEditor;
import metaanalysis.events.models.ExpandNode;
import metaanalysis.events.models.IApplicationEvent;
import metaanalysis.events.models.IUpdateEvent;
import metaanalysis.projects.guiandnodes.editors.ProjectEditorPanel;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

public class ProjectNode
extends AbstractApplicationNode
implements INodeEditor,
PropertyChangeListener {
    private final Project project;

    public ProjectNode(Project project, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children, Lookups.singleton((Object)project));
        this.project = project;
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/project_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/project_iconOpen.png");
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() {
        this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveProjectAA(this.project, this.applicationEventWorker));
    }

    public String getDisplayName() {
        return ((Project)this.getLookup().lookup(Project.class)).getName();
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new RunAnalysisAction(), null, new CloneProjectAction(), null, new RemoveProjectAction()};
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent")) {
            if (pce.getNewValue() instanceof ProjectEvents) {
                if (((ProjectEvents)pce.getNewValue()).getProject().getId() == this.project.getId() && pce.getNewValue() instanceof IUpdateEvent) {
                    this.project.copyFrom(((ProjectEvents)pce.getNewValue()).getProject());
                    this.setName(this.project.getName());
                    this.setDisplayName(this.project.getName());
                }
            } else if (pce.getNewValue() instanceof ProjectAnalysisDoneEvent && ((ProjectAnalysisDoneEvent)pce.getNewValue()).getProject().getId() == this.project.getId()) {
                this.applicationEventWorker.setApplicationEvent((IApplicationEvent)new ExpandNode((Node)this));
            }
        }
    }

    public ProjectEditorPanel getNodeEditor() {
        return new ProjectEditorPanel(this.project, this.applicationEventWorker, new GuiChecker(this.applicationEventWorker.getEditorPanelsUndoRedoManager(), TuliTuliTools.isAutoSelectContentFieldEnabled()));
    }

    private class CloneProjectAction
    extends AbstractAction
    implements Presenter.Popup {
        public CloneProjectAction() {
            this.putValue("Name", NbBundle.getMessage(ProjectNode.class, (String)"ProjectNode.clone.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String nome = JOptionPane.showInputDialog(null, NbBundle.getMessage(ProjectNode.class, (String)"ProjectNode.clone.actionName"), NbBundle.getMessage(ProjectNode.class, (String)"ProjectNode.clone.description"), 1);
            if (nome != null) {
                ProjectNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new CloneProjectAA(ProjectNode.this.project, nome, ProjectNode.this.applicationEventWorker));
            }
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/create_icon.png")));
            return x;
        }
    }

    private class RemoveProjectAction
    extends AbstractAction
    implements Presenter.Popup {
        public RemoveProjectAction() {
            this.putValue("Name", NbBundle.getMessage(RemoveProjectAction.class, (String)"ProjectNode.RemoveProjectAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProjectNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveProjectAA(ProjectNode.this.project, ProjectNode.this.applicationEventWorker));
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/delete_icon.png")));
            return x;
        }
    }

    private class RunAnalysisAction
    extends AbstractAction
    implements Presenter.Popup {
        public RunAnalysisAction() {
            this.putValue("Name", NbBundle.getMessage(RemoveProjectAction.class, (String)"ProjectNode.RunAnalysisAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProjectAnalysisRunner p = new ProjectAnalysisRunner(ProjectNode.this.applicationEventWorker, ProjectNode.this.project);
            p.start();
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/run_analysis_icon.png")));
            return x;
        }
    }
}

