/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.projects.guiandnodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import metaanalysis.actions.models.DefineProjectAA;
import metaanalysis.core.analysis.impl.ProjectAnalysisRunner;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Topic;
import metaanalysis.dataeditor.models.AbstractContainerNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class ProjectsContainerNode
extends AbstractContainerNode {
    protected final Topic topic;

    public ProjectsContainerNode(Topic topic, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children);
        this.topic = topic;
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/project_folder_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/project_folder_iconOpen.png");
    }

    public Action[] getActions(boolean popup) {
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        actions.add(new AddProjectAction());
        actions.add(null);
        actions.add(new RunAnalysisAction());
        return actions.toArray(new Action[actions.size()]);
    }

    public String getHtmlDisplayName() {
        return NbBundle.getMessage(ProjectsContainerNode.class, (String)"ProjectsContainerNode.displayName");
    }

    private class AddProjectAction
    extends AbstractAction
    implements Presenter.Popup {
        public AddProjectAction() {
            this.putValue("Name", NbBundle.getMessage(AddProjectAction.class, (String)"AddProjectAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String nome = JOptionPane.showInputDialog(null, NbBundle.getMessage(ProjectsContainerNode.class, (String)"ProjectsContainerNode.newProject"), NbBundle.getMessage(ProjectsContainerNode.class, (String)"ProjectsContainerNode.insertBarTitle"), 1);
            if (nome != null) {
                ProjectsContainerNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineProjectAA(ProjectsContainerNode.this.topic, nome, ProjectsContainerNode.this.applicationEventWorker));
            }
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/create_icon.png")));
            return x;
        }
    }

    private class RunAnalysisAction
    extends AbstractAction
    implements Presenter.Popup {
        public RunAnalysisAction() {
            this.putValue("Name", NbBundle.getMessage(RunAnalysisAction.class, (String)"ProjectContainerNode.RunAnalysisAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProjectAnalysisRunner p = new ProjectAnalysisRunner(ProjectsContainerNode.this.applicationEventWorker, ProjectsContainerNode.this.topic.getId());
            p.start();
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/run_analysis_icon.png")));
            return x;
        }
    }
}

