/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.projects.guiandnodes.childfactory;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import metaanalysis.core.entitycomparators.ProjectNameComparator;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ModeratorEvents;
import metaanalysis.core.functionsapi.events.ProjectEvents;
import metaanalysis.core.persistence.Preanalysis;
import metaanalysis.core.persistence.Project;
import metaanalysis.core.persistence.Topic;
import metaanalysis.events.models.ICreateEvent;
import metaanalysis.events.models.IDeleteEvent;
import metaanalysis.projects.guiandnodes.PreanalysisNode;
import metaanalysis.projects.guiandnodes.ProjectNode;
import metaanalysis.projects.guiandnodes.childfactory.PreanalysisChildFactory;
import metaanalysis.projects.guiandnodes.childfactory.ProjectChildFactory;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class ProjectsChildFactory
extends ChildFactory.Detachable<Object>
implements PropertyChangeListener {
    private final IApplicationManager applicationEventWorker;
    private final Topic topic;

    public ProjectsChildFactory(Topic topic, IApplicationManager applicationEventRegister) {
        this.topic = topic;
        this.applicationEventWorker = applicationEventRegister;
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
    }

    protected boolean createKeys(List<Object> list) {
        list.addAll(this.applicationEventWorker.getIDataFunction().getAllPreanalysisOfTopic(this.topic.getId()));
        List allProjectsOfTopic = this.applicationEventWorker.getIDataFunction().getAllProjectsOfTopic(this.topic.getId());
        Collections.sort(allProjectsOfTopic, new ProjectNameComparator());
        list.addAll(allProjectsOfTopic);
        return true;
    }

    protected Node createNodeForKey(Object key) {
        if (key instanceof Preanalysis) {
            return new PreanalysisNode((Preanalysis)key, this.applicationEventWorker, Children.create((ChildFactory)new PreanalysisChildFactory((Preanalysis)key, this.applicationEventWorker), (boolean)true));
        }
        if (key instanceof Project) {
            return new ProjectNode((Project)key, this.applicationEventWorker, Children.create((ChildFactory)new ProjectChildFactory((Project)key, this.applicationEventWorker), (boolean)true));
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent")) {
            if (pce.getNewValue() instanceof ModeratorEvents && (pce.getNewValue() instanceof IDeleteEvent || pce.getNewValue() instanceof ICreateEvent)) {
                this.refresh(true);
            }
            if (pce.getNewValue() instanceof ProjectEvents && (pce.getNewValue() instanceof ICreateEvent || pce.getNewValue() instanceof IDeleteEvent)) {
                this.refresh(true);
            }
        }
    }
}

