/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.projects.guiandnodes.editors;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.projects.guiandnodes.editors.CombineBean;
import org.openide.util.NbBundle;

public class CheckerPanel<T>
extends JPanel {
    Map<T, JCheckBox> elenco = new HashMap<T, JCheckBox>();
    private CombineBean combineBean = new CombineBean();
    boolean correlationShow;
    protected GuiChecker guiChecker;
    private JCheckBox allCheckedField;
    private JCheckBox allUncheckedField;
    protected JCheckBox combine;
    private JTextField correlationBetween;
    public JLabel correlationLabel1;
    private JLabel nameLabel;
    private JPanel pannelloInterno;
    private JScrollPane scroller;

    public CombineBean getCombineBean() {
        return this.combineBean;
    }

    public CheckerPanel(String name, Map<T, Boolean> elements, boolean combinePanel, boolean isCombined, boolean correlationPanel) {
        this(name, elements, combinePanel, isCombined, correlationPanel, null);
    }

    public CheckerPanel(String name, Map<T, Boolean> elements, boolean combinePanel, boolean isCombined, boolean correlationPanel, GuiChecker guiChecker) {
        this.initComponents();
        if (guiChecker == null) {
            this.guiChecker = new GuiChecker(TuliTuliTools.isAutoSelectContentFieldEnabled());
        }
        this.guiChecker = guiChecker;
        this.correlationShow = correlationPanel;
        if (!combinePanel) {
            this.combine.setVisible(false);
        }
        this.setCombineCheckbox(isCombined);
        TreeMap<T, Boolean> mappa = new TreeMap<T, Boolean>();
        mappa.putAll(elements);
        this.nameLabel.setText(name);
        this.nameLabel.setToolTipText(name);
        for (Object next : mappa.keySet()) {
            JCheckBox jCheckBox = new JCheckBox(next.toString(), (boolean)elements.get(next));
            jCheckBox.setBackground(StyleProvider.panelBackground);
            this.elenco.put(next, jCheckBox);
            this.pannelloInterno.add(this.elenco.get(next));
        }
    }

    public boolean isCorrelationShow() {
        return this.correlationShow;
    }

    public void setCorrelationShow(boolean correlationShow) {
        this.correlationShow = correlationShow;
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.nameLabel.setText(string);
    }

    public List<T> getCheckedObjects() {
        ArrayList<T> tmp = new ArrayList<T>();
        for (T x : this.elenco.keySet()) {
            if (!this.elenco.get(x).isSelected()) continue;
            tmp.add(x);
        }
        return tmp;
    }

    public List<T> getUncheckedObjects() {
        ArrayList<T> tmp = new ArrayList<T>();
        for (T x : this.elenco.keySet()) {
            if (this.elenco.get(x).isSelected()) continue;
            tmp.add(x);
        }
        return tmp;
    }

    public boolean isCombined() {
        return this.combine.isSelected();
    }

    public void setCombine(boolean value) {
        this.combine.setSelected(value);
    }

    private void initComponents() {
        this.scroller = new JScrollPane();
        this.pannelloInterno = new JPanel();
        this.nameLabel = new JLabel();
        this.combine = new JCheckBox();
        this.correlationLabel1 = new JLabel();
        this.correlationBetween = new JTextField();
        this.allUncheckedField = new JCheckBox();
        this.allCheckedField = new JCheckBox();
        this.setBackground(StyleProvider.panelBackground);
        this.setMaximumSize(new Dimension(200, 280));
        this.setMinimumSize(new Dimension(200, 280));
        this.setPreferredSize(new Dimension(200, 280));
        this.setRequestFocusEnabled(false);
        this.setSize(new Dimension(200, 280));
        this.pannelloInterno.setBackground(StyleProvider.panelBackground);
        this.pannelloInterno.setLayout(new BoxLayout(this.pannelloInterno, 3));
        this.scroller.setViewportView(this.pannelloInterno);
        this.nameLabel.setText(NbBundle.getMessage(CheckerPanel.class, (String)"CheckerPanel.nameLabel.text"));
        this.nameLabel.setMaximumSize(new Dimension(110, 16));
        this.nameLabel.setMinimumSize(new Dimension(110, 16));
        this.nameLabel.setPreferredSize(new Dimension(110, 16));
        this.nameLabel.setSize(new Dimension(110, 16));
        this.combine.setBackground(StyleProvider.panelBackground);
        this.combine.setText(NbBundle.getMessage(CheckerPanel.class, (String)"CheckerPanel.combine.text"));
        this.combine.setToolTipText(NbBundle.getMessage(CheckerPanel.class, (String)"CheckerPanel.combine.toolTipText"));
        this.combine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckerPanel.this.combineActionPerformed(evt);
            }
        });
        this.correlationLabel1.setText(NbBundle.getMessage(CheckerPanel.class, (String)"CheckerPanel.correlationLabel1.text"));
        this.correlationBetween.setHorizontalAlignment(4);
        this.correlationBetween.setText(NbBundle.getMessage(CheckerPanel.class, (String)"CheckerPanel.correlationBetween.text"));
        this.correlationBetween.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CheckerPanel.this.correlationBetweenFocusLost(evt);
            }
        });
        this.correlationBetween.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CheckerPanel.this.correlationBetweenKeyReleased(evt);
            }
        });
        this.allUncheckedField.setBackground(StyleProvider.panelBackground);
        this.allUncheckedField.setText(NbBundle.getMessage(CheckerPanel.class, (String)"CheckerPanel.allUncheckedField.text"));
        this.allUncheckedField.setToolTipText(NbBundle.getMessage(CheckerPanel.class, (String)"CheckerPanel.allUncheckedField.toolTipText"));
        this.allUncheckedField.setFocusPainted(false);
        this.allUncheckedField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckerPanel.this.allUncheckedFieldActionPerformed(evt);
            }
        });
        this.allCheckedField.setBackground(StyleProvider.panelBackground);
        this.allCheckedField.setSelected(true);
        this.allCheckedField.setText(NbBundle.getMessage(CheckerPanel.class, (String)"CheckerPanel.allCheckedField.text"));
        this.allCheckedField.setToolTipText(NbBundle.getMessage(CheckerPanel.class, (String)"CheckerPanel.allCheckedField.toolTipText"));
        this.allCheckedField.setFocusPainted(false);
        this.allCheckedField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckerPanel.this.allCheckedFieldActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.combine).addGroup(layout.createSequentialGroup().addComponent(this.correlationLabel1).addGap(12, 12, 12).addComponent(this.correlationBetween)).addGroup(layout.createSequentialGroup().addComponent(this.nameLabel, -2, 110, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.allCheckedField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allUncheckedField)).addComponent(this.scroller, -2, 184, -2)).addContainerGap(10, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.allCheckedField).addComponent(this.nameLabel, -2, 16, -2)).addComponent(this.allUncheckedField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scroller, -2, 170, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.combine).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.correlationLabel1).addComponent(this.correlationBetween, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void combineActionPerformed(ActionEvent evt) {
        this.combineBean.setCombine(this.combine.isSelected());
        if (this.isCorrelationShow() && this.combine.isSelected()) {
            this.showCorrelationElements(true);
        } else {
            this.showCorrelationElements(false);
        }
    }

    private void correlationBetweenKeyReleased(KeyEvent evt) {
        this.guiChecker.fieldChange(this.correlationBetween);
        this.validate();
    }

    private void correlationBetweenFocusLost(FocusEvent evt) {
        this.guiChecker.checkAndFixField(this.correlationBetween);
        this.guiChecker.checkAndFix();
        this.validate();
    }

    private void allUncheckedFieldActionPerformed(ActionEvent evt) {
        this.allUncheckedField.setSelected(false);
        Iterator<T> iterator = this.elenco.keySet().iterator();
        while (iterator.hasNext()) {
            this.elenco.get(iterator.next()).setSelected(false);
        }
    }

    private void allCheckedFieldActionPerformed(ActionEvent evt) {
        this.allCheckedField.setSelected(true);
        Iterator<T> iterator = this.elenco.keySet().iterator();
        while (iterator.hasNext()) {
            this.elenco.get(iterator.next()).setSelected(true);
        }
    }

    public final void setCombineCheckbox(boolean value) {
        boolean xx = value;
        if (!this.isCorrelationShow()) {
            xx = false;
        }
        this.combine.setSelected(value);
        this.combineBean.setCombine(value);
        this.showCorrelationElements(xx);
        this.validate();
    }

    private void showCorrelationElements(boolean xx) {
        this.correlationLabel1.setVisible(xx);
        this.correlationBetween.setVisible(xx);
    }

    public GuiChecker getGuiChecker() {
        return this.guiChecker;
    }

    public void setGuiChecker(GuiChecker guiChecker) {
        this.guiChecker = guiChecker;
    }

    public JTextField getCorrelationBetween() {
        return this.correlationBetween;
    }

    public void setCombineShow(boolean show) {
        this.combine.setVisible(show);
        this.validate();
    }
}

