/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.projects.guiandnodes.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalysis.analysis.models.AnalysisFilter;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Comparison;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorrecode;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Subgroup;
import metaanalysis.moderatorrecode.apis.IRecodeRole;
import metaanalysis.moderatorrecode.apis.ModeratorRecodeMachine;
import metaanalysis.projects.guiandnodes.editors.CheckerPanel;
import metaanalysis.projects.guiandnodes.editors.ModeratorCheckerPanel;
import metaanalysis.projects.guiandnodes.editors.ModeratorrecodeCheckerPanel;

public class PanelGenerator {
    public static CheckerPanel<Study> getStudiesPanel(long topicId, AnalysisFilter filter, IApplicationManager applicationEventWorker, GuiChecker guiChecker) {
        List allStudiesOfTopic = applicationEventWorker.getIDataFunction().getAllStudiesOfTopic(topicId);
        HashMap<Study, Boolean> elenco = new HashMap<Study, Boolean>();
        for (Study s : allStudiesOfTopic) {
            if (filter.getExcludedStudies().contains(new Long(s.getId()))) {
                elenco.put(s, Boolean.FALSE);
                continue;
            }
            elenco.put(s, Boolean.TRUE);
        }
        return new CheckerPanel<Study>("Studies", elenco, false, false, false, guiChecker);
    }

    public static CheckerPanel<Subgroup> getSubgroupsPanel(long topicId, AnalysisFilter filter, IApplicationManager applicationEventWorker, GuiChecker guiChecker) {
        List xxx = applicationEventWorker.getIDataFunction().getAllSubgroupsOfTopic(topicId);
        HashMap<Subgroup, Boolean> elenco = new HashMap<Subgroup, Boolean>();
        for (Subgroup s : xxx) {
            if (filter.getExcludedSubgroups().contains(new Integer(s.getId()))) {
                elenco.put(s, Boolean.FALSE);
                continue;
            }
            elenco.put(s, Boolean.TRUE);
        }
        Subgroup defaultSb = applicationEventWorker.getIDataFunction().getDefaultSubgroup();
        if (filter.getExcludedSubgroups().contains(new Integer(defaultSb.getId()))) {
            elenco.put(defaultSb, Boolean.FALSE);
        } else {
            elenco.put(defaultSb, Boolean.TRUE);
        }
        CheckerPanel<Subgroup> checkerPanel = new CheckerPanel<Subgroup>("Subgroups", elenco, true, filter.isCombineSubgroups(), false, guiChecker);
        checkerPanel.setCombine(filter.isCombineSubgroups());
        return checkerPanel;
    }

    public static CheckerPanel<Comparison> getComparisonsPanel(long topicId, AnalysisFilter filter, IApplicationManager applicationEventWorker, GuiChecker guiChecker) {
        List xxx = applicationEventWorker.getIDataFunction().getAllComparisonsOfTopic(topicId);
        HashMap<Comparison, Boolean> elenco = new HashMap<Comparison, Boolean>();
        for (Comparison s : xxx) {
            if (filter.getExcludedComparisons().contains(new Integer(s.getId()))) {
                elenco.put(s, Boolean.FALSE);
                continue;
            }
            elenco.put(s, Boolean.TRUE);
        }
        Comparison defaultC = applicationEventWorker.getIDataFunction().getDefaultComparison();
        if (filter.getExcludedComparisons().contains(new Integer(defaultC.getId()))) {
            elenco.put(defaultC, Boolean.FALSE);
        } else {
            elenco.put(defaultC, Boolean.TRUE);
        }
        CheckerPanel<Comparison> checkerPanel = new CheckerPanel<Comparison>("Comparisons", elenco, true, filter.isCombineComparisons(), false, guiChecker);
        checkerPanel.setCombine(filter.isCombineComparisons());
        return checkerPanel;
    }

    public static CheckerPanel<Integer> getTimepointsPanel(long topicId, AnalysisFilter filter, IApplicationManager applicationEventWorker, GuiChecker guiChecker) {
        int maxTime = applicationEventWorker.getIDataFunction().getMaxTimepointOfTopic(topicId);
        HashMap<Integer, Boolean> elenco = new HashMap<Integer, Boolean>();
        for (int i = 1; i < maxTime + 2; ++i) {
            if (filter.getExcludedTimepoints().contains(new Integer(i - 1))) {
                elenco.put(i, Boolean.FALSE);
                continue;
            }
            elenco.put(i, Boolean.TRUE);
        }
        CheckerPanel<Integer> checkerPanel = new CheckerPanel<Integer>("Waves", elenco, true, filter.isCombineTimepoints(), true, guiChecker);
        checkerPanel.setCombine(filter.isCombineTimepoints());
        return checkerPanel;
    }

    public static CheckerPanel<Outcome> getOutcomesPanel(long topicId, AnalysisFilter filter, IApplicationManager applicationEventWorker, GuiChecker guiChecker) {
        List xxx = applicationEventWorker.getIDataFunction().getAllOutcomesOfTopic(topicId);
        HashMap<Outcome, Boolean> elenco = new HashMap<Outcome, Boolean>();
        for (Outcome s : xxx) {
            if (filter.getExcludedOutcomes().contains(new Integer(s.getId()))) {
                elenco.put(s, Boolean.FALSE);
                continue;
            }
            elenco.put(s, Boolean.TRUE);
        }
        CheckerPanel<Outcome> checkerPanel = new CheckerPanel<Outcome>("Outcomes", elenco, true, filter.isCombineOutcomes(), true, guiChecker);
        checkerPanel.setCombine(filter.isCombineOutcomes());
        return checkerPanel;
    }

    public static CheckerPanel getModeratorrecodePanel(Moderatorrecode moderatorrecode, AnalysisFilter filter, IApplicationManager applicationEventWorker, GuiChecker guiChecker) {
        ArrayList roles = ModeratorRecodeMachine.toModeratorRecodingMachine((String)moderatorrecode.getModeratorrecodingmachine()).getRoles();
        HashMap<String, Boolean> elenco = new HashMap<String, Boolean>();
        List valori = (List)filter.getRecodedModeratorsExcludedValues().get(new Long(moderatorrecode.getId()));
        if (valori != null && valori.contains(filter.getNullValue())) {
            elenco.put(filter.getNullValue(), Boolean.FALSE);
        } else {
            elenco.put(filter.getNullValue(), Boolean.TRUE);
        }
        for (IRecodeRole r : roles) {
            if (valori != null && valori.contains(r.getCodedValue())) {
                elenco.put(r.getCodedValue(), Boolean.FALSE);
                continue;
            }
            elenco.put(r.getCodedValue(), Boolean.TRUE);
        }
        ModeratorrecodeCheckerPanel moderatorrecodeCheckerPanel = new ModeratorrecodeCheckerPanel(moderatorrecode, elenco, false, false, guiChecker);
        return moderatorrecodeCheckerPanel;
    }

    public static CheckerPanel getCategoricalModeratorPanel(Moderator moderator, AnalysisFilter filter, IApplicationManager applicationEventWorker, GuiChecker guiChecker) {
        List valori;
        HashMap<String, Boolean> elenco = new HashMap<String, Boolean>();
        String[] valoriDeiModeratori = new String[]{};
        if (moderator.getDefvalues() != null && !moderator.getDefvalues().equals("")) {
            valoriDeiModeratori = moderator.getDefvalues().split("\n");
        }
        if ((valori = (List)filter.getCategoricalModeratorsExcludedValues().get(new Integer(moderator.getId()))) != null && valori.contains(filter.getNullValue())) {
            elenco.put(filter.getNullValue(), Boolean.FALSE);
        } else {
            elenco.put(filter.getNullValue(), Boolean.TRUE);
        }
        for (String x : valoriDeiModeratori) {
            if (valori != null && valori.contains(x)) {
                elenco.put(x, Boolean.FALSE);
                continue;
            }
            elenco.put(x, Boolean.TRUE);
        }
        ModeratorCheckerPanel moderatorCheckerPanel = new ModeratorCheckerPanel(moderator, elenco, false, false, guiChecker);
        return moderatorCheckerPanel;
    }
}

