/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.projects.guiandnodes.editors;

import formattazione.numeri.MyNumberFormatter;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import metaanalsysis.guiutil.guicheckers.AbstractRole;
import metaanalsysis.guiutil.guicheckers.FieldCorrelationRole;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalysis.actions.models.UpdatePreanalysisAA;
import metaanalysis.analysis.models.AnalysisFilter;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.core.analysis.impl.PreAnalysisRunner;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.PreanalysisUpdatedEvent;
import metaanalysis.core.persistence.Comparison;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Preanalysis;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Subgroup;
import metaanalysis.core.persistence.Topic;
import metaanalysis.dataeditor.models.AbstractEditorPanel;
import metaanalysis.dataeditor.models.InconsistentEditorPanel;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.events.models.IApplicationEvent;
import metaanalysis.projects.guiandnodes.editors.CheckerPanel;
import metaanalysis.projects.guiandnodes.editors.PanelGenerator;
import metaanalysis.projects.guiandnodes.editors.ProjectEditorPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PreAnalysisEditorPanel
extends AbstractEditorPanel {
    private final int preanalysisId;
    private Preanalysis preanalysis = null;
    private AnalysisFilter filter = null;
    private CheckerPanel<Study> studiesPanel;
    private CheckerPanel<Subgroup> subgroupsPanel;
    private CheckerPanel<Comparison> comparisonsPanel;
    private CheckerPanel<Integer> timepointsPanel = null;
    private CheckerPanel<Outcome> outcomesPanel = null;
    private String oldSelectedES = null;
    protected MyNumberFormatter myNumberFormatter;
    private JLabel EffectSizeTypeLabel;
    private JComboBox analysisModelField;
    private JComboBox effectSizeTypeField;
    private JLabel modelLabel;
    private JButton saveAndRunButton;
    private JPanel variablesPanel;

    public PreAnalysisEditorPanel(int preanalysisId, IApplicationManager applicationEventWorker, GuiChecker guiChecker) {
        super(applicationEventWorker, guiChecker);
        this.myNumberFormatter = applicationEventWorker.getMyNumberFormatter();
        this.preanalysisId = preanalysisId;
        this.initComponents();
        this.reloadAll();
    }

    private void initComponents() {
        this.EffectSizeTypeLabel = new JLabel();
        this.modelLabel = new JLabel();
        this.effectSizeTypeField = new JComboBox();
        this.analysisModelField = new JComboBox();
        this.saveAndRunButton = new JButton();
        this.variablesPanel = new JPanel();
        this.setBackground(StyleProvider.panelBackground);
        Mnemonics.setLocalizedText((JLabel)this.EffectSizeTypeLabel, (String)NbBundle.getMessage(PreAnalysisEditorPanel.class, (String)"PreAnalysisEditorPanel.EffectSizeTypeLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.modelLabel, (String)NbBundle.getMessage(PreAnalysisEditorPanel.class, (String)"PreAnalysisEditorPanel.modelLabel.text"));
        this.effectSizeTypeField.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.effectSizeTypeField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PreAnalysisEditorPanel.this.effectSizeTypeFieldItemStateChanged(evt);
            }
        });
        this.analysisModelField.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        Mnemonics.setLocalizedText((AbstractButton)this.saveAndRunButton, (String)NbBundle.getMessage(PreAnalysisEditorPanel.class, (String)"PreAnalysisEditorPanel.saveAndRunButton.text"));
        this.saveAndRunButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreAnalysisEditorPanel.this.saveAndRunButtonActionPerformed(evt);
            }
        });
        this.variablesPanel.setBackground(StyleProvider.panelBackground);
        this.variablesPanel.setMaximumSize(new Dimension(1000, 300));
        this.variablesPanel.setMinimumSize(new Dimension(1000, 300));
        this.variablesPanel.setPreferredSize(new Dimension(1000, 300));
        this.variablesPanel.setSize(new Dimension(1000, 300));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.saveAndRunButton).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.EffectSizeTypeLabel, -1, 113, Short.MAX_VALUE).addComponent(this.modelLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.effectSizeTypeField, -2, -1, -2).addComponent(this.analysisModelField, -2, -1, -2)))).addComponent(this.variablesPanel, -2, 1092, -2)).addContainerGap(50, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.EffectSizeTypeLabel).addComponent(this.effectSizeTypeField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.modelLabel).addComponent(this.analysisModelField, -2, -1, -2)).addGap(12, 12, 12).addComponent(this.saveAndRunButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.variablesPanel, -2, 300, -2).addContainerGap(33, Short.MAX_VALUE)));
    }

    private void saveAndRunButtonActionPerformed(ActionEvent evt) {
        this.filter.setEffectSizeType(this.effectSizeTypeField.getSelectedItem().toString());
        if (this.analysisModelField.getSelectedItem().toString().equals(NbBundle.getMessage(StyleProvider.class, (String)"analysis.model.both"))) {
            this.filter.setRandomMode(true);
            this.filter.setFixedMode(true);
        } else if (this.analysisModelField.getSelectedItem().toString().equals(NbBundle.getMessage(StyleProvider.class, (String)"analysis.model.random"))) {
            this.filter.setRandomMode(true);
            this.filter.setFixedMode(false);
        } else if (this.analysisModelField.getSelectedItem().toString().equals(NbBundle.getMessage(StyleProvider.class, (String)"analysis.model.fixed"))) {
            this.filter.setRandomMode(false);
            this.filter.setFixedMode(true);
        }
        this.filter.getExcludedStudies().clear();
        List<Study> uncheckedObjectsS = this.studiesPanel.getUncheckedObjects();
        for (Study study : uncheckedObjectsS) {
            this.filter.getExcludedStudies().add(study.getId());
        }
        this.filter.getExcludedSubgroups().clear();
        List<Subgroup> uncheckedObjects = this.subgroupsPanel.getUncheckedObjects();
        for (Subgroup subgroup : uncheckedObjects) {
            this.filter.getExcludedSubgroups().add(subgroup.getId());
        }
        this.filter.setCombineSubgroups(this.subgroupsPanel.isCombined());
        this.filter.getExcludedComparisons().clear();
        List<Comparison> list = this.comparisonsPanel.getUncheckedObjects();
        for (Comparison comparison : list) {
            this.filter.getExcludedComparisons().add(comparison.getId());
        }
        this.filter.setCombineComparisons(this.comparisonsPanel.isCombined());
        this.filter.getExcludedTimepoints().clear();
        List<Integer> list2 = this.timepointsPanel.getUncheckedObjects();
        for (Integer n : list2) {
            this.filter.getExcludedTimepoints().add(n - 1);
        }
        this.filter.setCombineTimepoints(this.timepointsPanel.isCombined());
        this.filter.getExcludedOutcomes().clear();
        List<Outcome> list3 = this.outcomesPanel.getUncheckedObjects();
        for (Outcome x : list3) {
            this.filter.getExcludedOutcomes().add(x.getId());
        }
        this.filter.setCombineOutcomes(this.outcomesPanel.isCombined());
        this.filter.setCorrelationBetweenTimepoints(this.timepointsPanel.getGuiChecker().getRole(this.timepointsPanel.getCorrelationBetween()).getDoubleValue().doubleValue());
        this.filter.setCorrelationBetweenOutcomes(this.outcomesPanel.getGuiChecker().getRole(this.outcomesPanel.getCorrelationBetween()).getDoubleValue().doubleValue());
        this.preanalysis.setFilter(AnalysisFilter.writeAnalysisFilter((AnalysisFilter)this.filter));
        this.getIApplicationManager().getApplicationActionHandler().runAction((IApplicationActionModel)new UpdatePreanalysisAA(this.preanalysis, this.getIApplicationManager()));
        PreAnalysisRunner preAnalysisRunner = new PreAnalysisRunner(this.applicationEventWorker, this.preanalysis);
        preAnalysisRunner.start();
    }

    private void effectSizeTypeFieldItemStateChanged(ItemEvent evt) {
        if (this.effectSizeTypeField.getSelectedItem() != null) {
            if (this.effectSizeTypeField.getSelectedItem().toString().equals("")) {
                if (this.oldSelectedES == null) {
                    this.oldSelectedES = this.effectSizeTypeField.getItemAt(0).toString();
                }
                this.effectSizeTypeField.setSelectedItem(this.oldSelectedES);
            } else {
                this.oldSelectedES = this.effectSizeTypeField.getSelectedItem().toString();
            }
        }
    }

    public final void reloadAll() {
        this.analysisModelField.removeAllItems();
        this.analysisModelField.addItem(NbBundle.getMessage(StyleProvider.class, (String)"analysis.model.random"));
        this.analysisModelField.addItem(NbBundle.getMessage(StyleProvider.class, (String)"analysis.model.fixed"));
        this.analysisModelField.addItem(NbBundle.getMessage(StyleProvider.class, (String)"analysis.model.both"));
        Topic t = this.applicationEventWorker.getIDataFunction().getFirstOpenedTopic();
        this.effectSizeTypeField.removeAllItems();
        if (t != null) {
            if (t.getTopictype() == Topic.oneGroupSummaryTopicType) {
                for (String x : IEffectSizeValue.singleGroupSummaryGroupedTypeLabels) {
                    this.effectSizeTypeField.addItem(x);
                }
            } else {
                for (String x : IEffectSizeValue.standardMetaAnalysisValueTypeLabels) {
                    this.effectSizeTypeField.addItem(x);
                }
            }
        }
        this.guiChecker.svuota();
        this.preanalysis = this.getIApplicationManager().getIDataFunction().getPreanalysis(this.preanalysisId);
        this.filter = AnalysisFilter.readAnalysisFilter((String)this.preanalysis.getFilter());
        if (this.filter == null) {
            this.filter = new AnalysisFilter();
        }
        if (this.filter.isRandomMode() && this.filter.isFixedMode()) {
            this.analysisModelField.setSelectedItem(NbBundle.getMessage(StyleProvider.class, (String)"analysis.model.both"));
        } else if (this.filter.isRandomMode()) {
            this.analysisModelField.setSelectedItem(NbBundle.getMessage(StyleProvider.class, (String)"analysis.model.random"));
        } else if (this.filter.isFixedMode()) {
            this.analysisModelField.setSelectedItem(NbBundle.getMessage(StyleProvider.class, (String)"analysis.model.fixed"));
        }
        this.effectSizeTypeField.setSelectedItem(this.filter.getEffectSizeType());
        this.variablesPanel.removeAll();
        this.studiesPanel = PanelGenerator.getStudiesPanel(this.preanalysis.getTopicId(), this.filter, this.applicationEventWorker, this.getGuiChecker());
        this.variablesPanel.add(this.studiesPanel);
        this.subgroupsPanel = PanelGenerator.getSubgroupsPanel(this.preanalysis.getTopicId(), this.filter, this.applicationEventWorker, this.getGuiChecker());
        this.variablesPanel.add(this.subgroupsPanel);
        this.comparisonsPanel = PanelGenerator.getComparisonsPanel(this.preanalysis.getTopicId(), this.filter, this.applicationEventWorker, this.getGuiChecker());
        this.variablesPanel.add(this.comparisonsPanel);
        this.timepointsPanel = PanelGenerator.getTimepointsPanel(this.preanalysis.getTopicId(), this.filter, this.applicationEventWorker, this.getGuiChecker());
        this.variablesPanel.add(this.timepointsPanel);
        this.guiChecker.addRole((AbstractRole)new FieldCorrelationRole(this.timepointsPanel.getCorrelationBetween(), Double.valueOf(this.filter.getCorrelationBetweenTimepoints()), this.myNumberFormatter));
        this.outcomesPanel = PanelGenerator.getOutcomesPanel(this.preanalysis.getTopicId(), this.filter, this.applicationEventWorker, this.getGuiChecker());
        this.variablesPanel.add(this.outcomesPanel);
        this.guiChecker.addRole((AbstractRole)new FieldCorrelationRole(this.outcomesPanel.getCorrelationBetween(), Double.valueOf(this.filter.getCorrelationBetweenOutcomes()), this.myNumberFormatter));
        this.add(this.variablesPanel);
        this.guiChecker.checkWhitoutFix();
        this.validate();
    }

    public boolean readApplicationEvent(IApplicationEvent event) throws InconsistentEditorPanel {
        if (event instanceof PreanalysisUpdatedEvent) {
            this.reloadAll();
            return true;
        }
        return false;
    }

    public String getBarTitle() {
        return NbBundle.getMessage(ProjectEditorPanel.class, (String)"PreAnalysisEditor.barTitle");
    }
}

