/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.projects.guiandnodes.editors;

import formattazione.numeri.MyNumberFormatter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import metaanalsysis.guiutil.guicheckers.AbstractRole;
import metaanalsysis.guiutil.guicheckers.FieldCorrelationRole;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalysis.actions.models.UpdateProjectAA;
import metaanalysis.analysis.models.AnalysisFilter;
import metaanalysis.application.style.BigTitle;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.core.analysis.impl.ProjectAnalysisRunner;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.DataBaseEvents;
import metaanalysis.core.functionsapi.events.ProjectDeletedEvent;
import metaanalysis.core.functionsapi.events.ProjectEvents;
import metaanalysis.core.functionsapi.events.ProjectResurrectionEvent;
import metaanalysis.core.functionsapi.events.ProjectUpdatedEvent;
import metaanalysis.core.persistence.Comparison;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorrecode;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Project;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Subgroup;
import metaanalysis.core.persistence.Topic;
import metaanalysis.dataeditor.models.AbstractEditorPanel;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.events.models.IApplicationEvent;
import metaanalysis.projects.guiandnodes.editors.CheckerPanel;
import metaanalysis.projects.guiandnodes.editors.PanelGenerator;
import metaanalysis.projects.guiandnodes.editors.ProjectEditorPanel_Top;
import metaanalysis.projects.guiandnodes.editors.SingleAnalysisGate;
import org.openide.util.NbBundle;

public final class ProjectEditorPanel
extends AbstractEditorPanel {
    private ProjectEditorPanel_Top topPanel;
    private Project project = null;
    public CheckerPanel<Study> studiesPanel;
    public CheckerPanel<Subgroup> subgroupsPanel;
    public CheckerPanel<Comparison> comparisonsPanel;
    public CheckerPanel<Integer> timepointsPanel = null;
    public CheckerPanel<Outcome> outcomesPanel = null;
    public Map<Integer, CheckerPanel> moderatorsPanelMap = new HashMap<Integer, CheckerPanel>();
    public Map<Long, CheckerPanel> recodedModeratorsPanelMap = new HashMap<Long, CheckerPanel>();
    private AnalysisFilter readAnalysisFilter;
    protected MyNumberFormatter myNumberFormatter;
    Map<Moderator, SingleAnalysisGate> mappaAnalisiModeratori = new HashMap<Moderator, SingleAnalysisGate>();
    Map<Moderatorrecode, SingleAnalysisGate> mappaAnalisiRicodificheModeratori = new HashMap<Moderatorrecode, SingleAnalysisGate>();

    public ProjectEditorPanel(Project project, IApplicationManager applicationEventWorker, GuiChecker guiChecker) {
        super(applicationEventWorker, guiChecker);
        this.myNumberFormatter = applicationEventWorker.getMyNumberFormatter();
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.project = project;
        this.reloadAll();
    }

    public void reloadAll() {
        this.guiChecker.svuota();
        this.readAnalysisFilter = AnalysisFilter.readAnalysisFilter((String)this.project.getFilter());
        this.removeAll();
        this.topPanel = new ProjectEditorPanel_Top();
        this.topPanel.setAlignmentX(0.0f);
        this.topPanel.model.addItem(NbBundle.getMessage(StyleProvider.class, (String)"analysis.model.random"));
        this.topPanel.model.addItem(NbBundle.getMessage(StyleProvider.class, (String)"analysis.model.fixed"));
        this.topPanel.model.addItem(NbBundle.getMessage(StyleProvider.class, (String)"analysis.model.both"));
        this.topPanel.noteArea.setText(this.project.getNote());
        this.topPanel.esType.removeAllItems();
        Topic t = this.applicationEventWorker.getIDataFunction().getFirstOpenedTopic();
        this.topPanel.esType.removeAllItems();
        if (t != null) {
            if (t.getTopictype() == Topic.oneGroupSummaryTopicType) {
                for (String x : IEffectSizeValue.singleGroupSummaryGroupedTypeLabels) {
                    this.topPanel.esType.addItem(x);
                }
            } else {
                for (String x : IEffectSizeValue.standardMetaAnalysisValueTypeLabels) {
                    this.topPanel.esType.addItem(x);
                }
            }
        }
        this.topPanel.projectNameField.setText(this.project.getName());
        if (this.readAnalysisFilter.isRandomMode() && this.readAnalysisFilter.isFixedMode()) {
            this.topPanel.model.setSelectedItem(NbBundle.getMessage(StyleProvider.class, (String)"analysis.model.both"));
        } else if (this.readAnalysisFilter.isRandomMode()) {
            this.topPanel.model.setSelectedItem(NbBundle.getMessage(StyleProvider.class, (String)"analysis.model.random"));
        } else if (this.readAnalysisFilter.isFixedMode()) {
            this.topPanel.model.setSelectedItem(NbBundle.getMessage(StyleProvider.class, (String)"analysis.model.fixed"));
        }
        this.topPanel.esType.setSelectedItem(this.readAnalysisFilter.getEffectSizeType());
        this.topPanel.noteArea.setText(this.project.getNote());
        this.topPanel.searchBias.setSelectedItem(this.readAnalysisFilter.getPublicationBiasSearch() == AnalysisFilter.leftSideSearch ? "left" : "right");
        BigTitle bigTitle = new BigTitle(NbBundle.getMessage(ProjectEditorPanel.class, (String)"AnalysesProgrammer.section"));
        bigTitle.setAlignmentX(0.0f);
        this.add((Component)bigTitle);
        this.add(this.topPanel);
        this.add(Box.createVerticalStrut(30));
        JButton saveAndRunButton = new JButton(NbBundle.getMessage(ProjectEditorPanel.class, (String)"save.button"));
        saveAndRunButton.setAlignmentX(0.0f);
        saveAndRunButton.setMaximumSize(new Dimension(200, 60));
        saveAndRunButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectEditorPanel.this.saveAndRunButtonActionPerformed(evt);
            }
        });
        this.guiChecker.getEligibleObjects().add(saveAndRunButton);
        this.add(saveAndRunButton);
        this.add(Box.createVerticalStrut(50));
        List allModeratorsOfTopic = this.applicationEventWorker.getIDataFunction().getAllModeratorsOfTopic(this.project.getTopicId().longValue());
        BigTitle bigTitle2 = new BigTitle(NbBundle.getMessage(ProjectEditorPanel.class, (String)"FilterPanels.section"));
        bigTitle2.setAlignmentX(0.0f);
        this.add((Component)bigTitle2);
        JPanel variablesPanel = new JPanel();
        variablesPanel.setLayout(new FlowLayout(0));
        variablesPanel.setBackground(StyleProvider.panelBackground);
        variablesPanel.setAlignmentX(0.0f);
        variablesPanel.setMaximumSize(new Dimension(2000, 280));
        this.studiesPanel = PanelGenerator.getStudiesPanel(this.project.getTopicId(), this.readAnalysisFilter, this.applicationEventWorker, this.getGuiChecker());
        variablesPanel.add(this.studiesPanel);
        this.subgroupsPanel = PanelGenerator.getSubgroupsPanel(this.project.getTopicId(), this.readAnalysisFilter, this.applicationEventWorker, this.getGuiChecker());
        variablesPanel.add(this.subgroupsPanel);
        this.comparisonsPanel = PanelGenerator.getComparisonsPanel(this.project.getTopicId(), this.readAnalysisFilter, this.applicationEventWorker, this.getGuiChecker());
        variablesPanel.add(this.comparisonsPanel);
        this.timepointsPanel = PanelGenerator.getTimepointsPanel(this.project.getTopicId(), this.readAnalysisFilter, this.applicationEventWorker, this.getGuiChecker());
        variablesPanel.add(this.timepointsPanel);
        this.guiChecker.addRole((AbstractRole)new FieldCorrelationRole(this.timepointsPanel.getCorrelationBetween(), Double.valueOf(this.readAnalysisFilter.getCorrelationBetweenTimepoints()), this.myNumberFormatter));
        this.outcomesPanel = PanelGenerator.getOutcomesPanel(this.project.getTopicId(), this.readAnalysisFilter, this.applicationEventWorker, this.getGuiChecker());
        variablesPanel.add(this.outcomesPanel);
        this.guiChecker.addRole((AbstractRole)new FieldCorrelationRole(this.outcomesPanel.getCorrelationBetween(), Double.valueOf(this.readAnalysisFilter.getCorrelationBetweenOutcomes()), this.myNumberFormatter));
        this.add(variablesPanel);
        int conto = 0;
        int limite = 5;
        JPanel moderatorsAndRecodesPanel = this.getModeratorsAndRecodesPanel();
        for (Moderator m : allModeratorsOfTopic) {
            if (m.getModeratortype() == Moderator.categoricalType) {
                CheckerPanel categoricalModeratorPanel = PanelGenerator.getCategoricalModeratorPanel(m, this.readAnalysisFilter, this.applicationEventWorker, this.getGuiChecker());
                this.moderatorsPanelMap.put(m.getId(), categoricalModeratorPanel);
                moderatorsAndRecodesPanel.add(categoricalModeratorPanel);
                if (++conto % limite == 0) {
                    this.add(moderatorsAndRecodesPanel);
                    moderatorsAndRecodesPanel = this.getModeratorsAndRecodesPanel();
                }
            }
            List allModeratorrecodeOfModerator = this.applicationEventWorker.getIDataFunction().getAllModeratorrecodeOfModerator(m);
            for (Moderatorrecode mr : allModeratorrecodeOfModerator) {
                CheckerPanel moderatorrecodePanel = PanelGenerator.getModeratorrecodePanel(mr, this.readAnalysisFilter, this.applicationEventWorker, this.getGuiChecker());
                this.recodedModeratorsPanelMap.put(mr.getId(), moderatorrecodePanel);
                moderatorsAndRecodesPanel.add(moderatorrecodePanel);
                if (++conto % limite != 0) continue;
                this.add(moderatorsAndRecodesPanel);
                moderatorsAndRecodesPanel = this.getModeratorsAndRecodesPanel();
            }
        }
        if (conto % limite != 0) {
            this.add(moderatorsAndRecodesPanel);
        }
        this.add(Box.createVerticalStrut(40));
        BigTitle bigTitle1 = new BigTitle(NbBundle.getMessage(ProjectEditorPanel.class, (String)"ModeratorsAnalyses.section"));
        bigTitle1.setAlignmentX(0.0f);
        this.add((Component)bigTitle1);
        JPanel singoleAnalisiPanel = new JPanel();
        singoleAnalisiPanel.setLayout(new BoxLayout(singoleAnalisiPanel, 1));
        singoleAnalisiPanel.setAlignmentX(0.0f);
        for (Moderator m : allModeratorsOfTopic) {
            Integer tSq = (Integer)this.readAnalysisFilter.getCategoricalTSquareType().get(m.getId());
            if (tSq == null) {
                tSq = 0;
            }
            SingleAnalysisGate singleAnalysisGate = new SingleAnalysisGate(m.getName(), !this.readAnalysisFilter.getExcludedModerators().contains(m.getId()), m.getModeratortype() == Moderator.categoricalType, tSq);
            this.mappaAnalisiModeratori.put(m, singleAnalysisGate);
            singoleAnalisiPanel.add((Component)((Object)singleAnalysisGate));
            List allModeratorrecodeOfModerator = this.applicationEventWorker.getIDataFunction().getAllModeratorrecodeOfModerator(m);
            for (Moderatorrecode mr : allModeratorrecodeOfModerator) {
                Integer tSqMR = (Integer)this.readAnalysisFilter.getRecodedTSquareType().get(mr.getId());
                if (tSqMR == null) {
                    tSqMR = 0;
                }
                SingleAnalysisGate singleAnalysisGate1 = new SingleAnalysisGate(mr.getName(), !this.readAnalysisFilter.getExcludedRecodedModerators().contains(mr.getId()), true, tSqMR);
                this.mappaAnalisiRicodificheModeratori.put(mr, singleAnalysisGate1);
                singoleAnalisiPanel.add((Component)((Object)singleAnalysisGate1));
            }
        }
        singoleAnalisiPanel.setSize(700, 39 * this.mappaAnalisiRicodificheModeratori.keySet().size() + 39 * this.mappaAnalisiModeratori.keySet().size());
        this.add(singoleAnalisiPanel);
        this.add(Box.createVerticalGlue());
        this.guiChecker.checkWhitoutFix();
    }

    private JPanel getModeratorsAndRecodesPanel() {
        JPanel moderatorsAndRecodesPanel = new JPanel();
        moderatorsAndRecodesPanel.setLayout(new FlowLayout(0));
        moderatorsAndRecodesPanel.setBackground(StyleProvider.panelBackground);
        moderatorsAndRecodesPanel.setAlignmentX(0.0f);
        moderatorsAndRecodesPanel.setMaximumSize(new Dimension(2000, 300));
        return moderatorsAndRecodesPanel;
    }

    private void saveAndRunButtonActionPerformed(ActionEvent evt) {
        int i;
        this.project.setName(this.topPanel.projectNameField.getText());
        AnalysisFilter f = new AnalysisFilter();
        List<Study> uncheckedObjectsS = this.studiesPanel.getUncheckedObjects();
        for (Study study : uncheckedObjectsS) {
            f.getExcludedStudies().add(study.getId());
        }
        List<Subgroup> uncheckedObjects = this.subgroupsPanel.getUncheckedObjects();
        for (Subgroup subgroup : uncheckedObjects) {
            f.getExcludedSubgroups().add(subgroup.getId());
        }
        f.setCombineSubgroups(this.subgroupsPanel.isCombined());
        List<Comparison> list = this.comparisonsPanel.getUncheckedObjects();
        for (Comparison comparison : list) {
            f.getExcludedComparisons().add(comparison.getId());
        }
        f.setCombineComparisons(this.comparisonsPanel.isCombined());
        List<Integer> list2 = this.timepointsPanel.getUncheckedObjects();
        for (Integer n : list2) {
            f.getExcludedTimepoints().add(n - 1);
        }
        f.setCombineTimepoints(this.timepointsPanel.isCombined());
        List<Outcome> list3 = this.outcomesPanel.getUncheckedObjects();
        for (Outcome outcome : list3) {
            f.getExcludedOutcomes().add(outcome.getId());
        }
        f.setCombineOutcomes(this.outcomesPanel.isCombined());
        for (Moderator moderator : this.mappaAnalisiModeratori.keySet()) {
            if (!this.mappaAnalisiModeratori.get(moderator).isChecked()) {
                f.getExcludedModerators().add(moderator.getId());
            }
            for (i = 0; i < AnalysisFilter.tSquareType.length; ++i) {
                if (!this.mappaAnalisiModeratori.get(moderator).getCombineType().equals(AnalysisFilter.tSquareType[i])) continue;
                f.getCategoricalTSquareType().put(moderator.getId(), i);
            }
        }
        for (Moderatorrecode moderatorrecode : this.mappaAnalisiRicodificheModeratori.keySet()) {
            if (!this.mappaAnalisiRicodificheModeratori.get(moderatorrecode).isChecked()) {
                f.getExcludedRecodedModerators().add(moderatorrecode.getId());
            }
            for (i = 0; i < AnalysisFilter.tSquareType.length; ++i) {
                if (!this.mappaAnalisiRicodificheModeratori.get(moderatorrecode).getCombineType().equals(AnalysisFilter.tSquareType[i])) continue;
                f.getRecodedTSquareType().put(moderatorrecode.getId(), i);
            }
        }
        for (Integer n : this.moderatorsPanelMap.keySet()) {
            f.getCategoricalModeratorsExcludedValues().put(n, this.moderatorsPanelMap.get(n).getUncheckedObjects());
        }
        for (Long l : this.recodedModeratorsPanelMap.keySet()) {
            f.getRecodedModeratorsExcludedValues().put(l, this.recodedModeratorsPanelMap.get(l).getUncheckedObjects());
        }
        if (this.topPanel.model.getSelectedItem().toString().equals(NbBundle.getMessage(StyleProvider.class, (String)"analysis.model.both"))) {
            f.setRandomMode(true);
            f.setFixedMode(true);
        } else if (this.topPanel.model.getSelectedItem().toString().equals(NbBundle.getMessage(StyleProvider.class, (String)"analysis.model.random"))) {
            f.setRandomMode(true);
            f.setFixedMode(false);
        } else if (this.topPanel.model.getSelectedItem().toString().equals(NbBundle.getMessage(StyleProvider.class, (String)"analysis.model.fixed"))) {
            f.setRandomMode(false);
            f.setFixedMode(true);
        }
        f.setEffectSizeType(this.topPanel.esType.getSelectedItem().toString());
        f.setCorrelationBetweenTimepoints(this.timepointsPanel.getGuiChecker().getRole(this.timepointsPanel.getCorrelationBetween()).getDoubleValue().doubleValue());
        f.setCorrelationBetweenOutcomes(this.outcomesPanel.getGuiChecker().getRole(this.outcomesPanel.getCorrelationBetween()).getDoubleValue().doubleValue());
        f.setPublicationBiasSearch(this.topPanel.searchBias.getSelectedItem().toString().equals("left") ? 0 : 1);
        this.project.setNote(this.topPanel.noteArea.getText());
        this.project.setFilter(AnalysisFilter.writeAnalysisFilter((AnalysisFilter)f));
        this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new UpdateProjectAA(this.project, this.applicationEventWorker));
        ProjectAnalysisRunner projectAnalysisRunner = new ProjectAnalysisRunner(this.applicationEventWorker, this.project);
        projectAnalysisRunner.start();
    }

    public boolean readApplicationEvent(IApplicationEvent event) {
        if (event instanceof DataBaseEvents) {
            if (event instanceof ProjectEvents) {
                if (((ProjectEvents)event).getProject().getId() == this.project.getId()) {
                    if (event instanceof ProjectUpdatedEvent) {
                        this.project = this.applicationEventWorker.getIDataFunction().getProject(this.project.getId());
                        this.readAnalysisFilter = AnalysisFilter.readAnalysisFilter((String)this.project.getFilter());
                        this.reloadAll();
                    } else if (event instanceof ProjectDeletedEvent) {
                        this.scompari();
                    } else if (event instanceof ProjectResurrectionEvent) {
                        this.appari();
                    }
                    return true;
                }
            } else {
                this.project = this.applicationEventWorker.getIDataFunction().getProject(this.project.getId());
                this.readAnalysisFilter = AnalysisFilter.readAnalysisFilter((String)this.project.getFilter());
                this.reloadAll();
            }
            return true;
        }
        return false;
    }

    public String getBarTitle() {
        return NbBundle.getMessage(ProjectEditorPanel.class, (String)"ProjectEditor.barTitle");
    }
}

