/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.dataeditor.basicplugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Properties;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.TopicDeletedEvent;
import metaanalysis.core.functionsapi.events.TopicOpenedEvent;
import metaanalysis.dataeditor.basicplugin.Bundle;
import metaanalysis.dataeditor.models.AbstractEditorPanel;
import metaanalysis.dataeditor.models.INodeEditor;
import metaanalysis.dataeditor.models.InconsistentEditorPanel;
import metaanalysis.dataeditor.models.ReadyPanel;
import metaanalysis.events.models.IApplicationEvent;
import metaanalysis.events.models.standardEvents.ApplicationOptionChange;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="DataEditorV2TopComponent", iconBase="metaanalysis/application/style/editing_option_icon.png", persistenceType=0)
public final class DataEditorV2TopComponent
extends TopComponent
implements LookupListener,
PropertyChangeListener {
    private INodeEditor lastNode = null;
    AbstractEditorPanel actualPanel = null;
    private IApplicationManager iApplicationManager = (IApplicationManager)Lookup.getDefault().lookup(IApplicationManager.class);
    private Lookup.Result<Node> result = null;

    public DataEditorV2TopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_DataEditorV2TopComponent());
        this.setToolTipText(Bundle.HINT_DataEditorV2TopComponent());
        this.putClientProperty("netbeans.winsys.tc.closing_disabled", Boolean.TRUE);
        this.iApplicationManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.iApplicationManager));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void componentOpened() {
        this.result = Utilities.actionsGlobalContext().lookupResult(Node.class);
        this.result.addLookupListener((LookupListener)this);
    }

    public void componentClosed() {
        this.result.removeLookupListener((LookupListener)this);
        this.result = null;
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public void resultChanged(LookupEvent lookupEvent) {
        Node n;
        Collection allEvents = this.result.allInstances();
        if (allEvents.isEmpty()) {
            return;
        }
        if (!allEvents.isEmpty() && (n = (Node)allEvents.iterator().next()) != null && n instanceof INodeEditor) {
            this.lastNode = (INodeEditor)n;
            this.aggiorna();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (this.actualPanel != null && pce.getPropertyName().equals("applicationEvent")) {
            IApplicationEvent event = (IApplicationEvent)pce.getNewValue();
            boolean readApplicationEvent = false;
            try {
                readApplicationEvent = this.actualPanel.readApplicationEvent(event);
            }
            catch (InconsistentEditorPanel ex) {
                this.lastNode = null;
                this.aggiorna();
                this.rimbalzaFocus();
            }
            if (readApplicationEvent) {
                this.rimbalzaFocus();
            } else if (pce.getNewValue() instanceof ApplicationOptionChange) {
                this.aggiorna();
            } else if (pce.getNewValue() instanceof TopicOpenedEvent) {
                this.actualPanel.scompari();
                this.rimbalzaFocus();
            } else if (pce.getNewValue() instanceof TopicDeletedEvent) {
                this.actualPanel.scompari();
                this.rimbalzaFocus();
            }
        }
    }

    private void aggiorna() {
        this.removeAll();
        if (this.lastNode == null) {
            this.add((Component)new ReadyPanel());
            this.actualPanel = null;
            this.setDisplayName("Editor");
        } else {
            this.actualPanel = this.lastNode.getNodeEditor();
            this.add(new JScrollPane((Component)this.actualPanel));
            this.setDisplayName(this.actualPanel.getBarTitle());
        }
        this.validate();
        this.rimbalzaFocus();
    }

    private void rimbalzaFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TopComponent top = TopComponent.getRegistry().getActivated();
                DataEditorV2TopComponent.this.requestActive();
                if (top != null) {
                    top.requestActive();
                }
            }
        });
    }

    public UndoRedo.Manager getUndoRedo() {
        return ((IApplicationManager)Lookup.getDefault().lookup(IApplicationManager.class)).getMainUndoRedoManager();
    }
}

