/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.hierarchicalsupport;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.DirectedGraph;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.LayeredGraph;

public class VertexInsertionLayerAssigner {
    public LayeredGraph assignLayers(DirectedGraph graph) {
        LayeredGraph layeredGraph = LayeredGraph.createGraph(graph);
        this.insertDummyVertices(layeredGraph);
        return layeredGraph;
    }

    private void insertDummyVertices(LayeredGraph graph) {
        DirectedGraph originalGraph = graph.getOriginalGraph();
        List<List<DirectedGraph.Vertex>> layers = graph.getLayers();
        for (int i = 0; i < layers.size(); ++i) {
            List<DirectedGraph.Vertex> layer = layers.get(i);
            for (DirectedGraph.Vertex v : layer) {
                int layerIndex = v.getNumber();
                ArrayList<DirectedGraph.Edge> edges = new ArrayList<DirectedGraph.Edge>(v.getOutgoingEdges());
                for (DirectedGraph.Edge e : edges) {
                    DirectedGraph.Vertex nv = e.getTarget();
                    int nvLayerIndex = nv.getNumber();
                    if (nvLayerIndex <= layerIndex + 1) continue;
                    DirectedGraph.DummyVertex dummyVertex = originalGraph.insertDummyVertex(e, DirectedGraph.DummyVertex.Type.BEND);
                    graph.assignLayer(dummyVertex, layerIndex + 1);
                }
            }
        }
    }
}

