/*
 * Decompiled with CFR 0.152.
 */
package internovi.core.power.tools;

import gui.alerts.GuiAlerts;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Locale;
import javax.swing.JOptionPane;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import os.tools.OSValidator;

public class PowerTools {
    public String baseUrl;
    public static String pk1 = "c17";
    public static String omega = "omega";
    public static String duration = "dura";
    public static String check_date = "chdat";
    public static String durdyn = "durdyn";
    public static String activation = "activation";
    public String checkUrl;
    public String ownerUrl;
    public String removedUrl;
    public String installerUrl;
    public String omegaTimeUrl;
    public String durataTimeUrl;
    public String activationTimeUrl;
    private String name;

    public PowerTools(String name, String baseUrl) {
        this.name = name;
        this.baseUrl = baseUrl;
        this.checkUrl = baseUrl + "/check.php?";
        this.ownerUrl = baseUrl + "/owner.php?";
        this.removedUrl = baseUrl + "/removed.php?";
        this.omegaTimeUrl = baseUrl + "/fine_date.php?";
        this.durataTimeUrl = baseUrl + "/duration.php?";
        this.activationTimeUrl = baseUrl + "/activation.php?";
        this.installerUrl = baseUrl + "/install.php?";
    }

    public boolean run() {
        return this.gestisciPower();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private boolean gestisciPower() {
        boolean installaLicenza;
        if (this.isExternalKey()) {
            return true;
        }
        if (!PowerTools.isLicenzaIntegra() && !(installaLicenza = this.installaLicenza())) {
            return false;
        }
        String readCodeFromUrl = null;
        try {
            readCodeFromUrl = this.readCodeFromUrl(this.checkUrl + "pk=" + PowerTools.getPk(pk1) + "&mac=" + PowerTools.getID() + "&name=" + this.getName());
            if (readCodeFromUrl.equals(NbBundle.getMessage(PowerTools.class, (String)"check.feedback.NOPK"))) {
                this.rimuoviLicenza();
                GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"check.feedback.message.NOPK")));
                return false;
            }
            if (readCodeFromUrl.equals(NbBundle.getMessage(PowerTools.class, (String)"check.feedback.NOMAC"))) {
                this.rimuoviLicenza();
                GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"check.feedback.message.NOMAC")));
                return false;
            }
            if (readCodeFromUrl.equals(NbBundle.getMessage(PowerTools.class, (String)"check.feedback.NO_NAME"))) {
                this.rimuoviLicenza();
                GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"check.feedback.message.NO_NAME")));
                return false;
            }
            if (readCodeFromUrl.equals(NbBundle.getMessage(PowerTools.class, (String)"check.feedback.DATABASE_ERROR"))) {
                GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"check.feedback.message.DATABASE_ERROR")));
                return false;
            }
            if (readCodeFromUrl.equals(NbBundle.getMessage(PowerTools.class, (String)"check.feedback.NOT_INSTALLED"))) {
                this.rimuoviLicenza();
                GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"check.feedback.message.NOT_INSTALLED")));
                return false;
            }
            if (readCodeFromUrl.equals(NbBundle.getMessage(PowerTools.class, (String)"check.feedback.INVALID_CODE"))) {
                this.rimuoviLicenza();
                GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"check.feedback.message.INVALID_CODE")));
                return false;
            }
            if (readCodeFromUrl.equals(NbBundle.getMessage(PowerTools.class, (String)"check.feedback.DISABLE"))) {
                this.rimuoviLicenza();
                GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"check.feedback.message.DISABLE")));
                return false;
            }
            if (readCodeFromUrl.equals(NbBundle.getMessage(PowerTools.class, (String)"check.feedback.STATUS_ERROR"))) {
                GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"check.feedback.message.STATUS_ERROR")));
                return false;
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        long ora = Math.round(1.0 * (double)new Date().getTime() / 1000.0);
        long salvata = Long.parseLong(PowerTools.getPk(check_date));
        long delta = Math.abs(ora - salvata);
        long oldDur = Long.parseLong(PowerTools.getPk(durdyn));
        long newDur = oldDur - delta;
        this.setCodice(durdyn, "" + newDur);
        this.setCodice(check_date, "" + ora);
        if (newDur < 0L) {
            this.rimuoviLicenza();
            GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"license.expired")));
            return false;
        }
        return true;
    }

    private boolean installaLicenza() {
        block15: {
            String pk = "metticelo";
            while (!PowerTools.checksumPK(pk)) {
                if (!pk.equals("metticelo")) {
                    GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"PK.invalidCode")));
                }
                if ((pk = JOptionPane.showInputDialog(null, NbBundle.getMessage(PowerTools.class, (String)"PK.name"), NbBundle.getMessage(PowerTools.class, (String)"PK.barTitle"), 1)) == null) {
                    GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"PK.invalidCode")));
                    return false;
                }
                pk = pk.toLowerCase(Locale.ENGLISH);
            }
            String macId = PowerTools.getID();
            try {
                String readCodeFromUrl = this.readCodeFromUrl(this.installerUrl + "pk=" + pk + "&mac=" + macId + "&name=" + this.getName());
                if (readCodeFromUrl == null) break block15;
                if (readCodeFromUrl.equals(NbBundle.getMessage(PowerTools.class, (String)"install.feedback.NOPK"))) {
                    GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"install.feedback.message.NOPK")));
                    return false;
                }
                if (readCodeFromUrl.equals(NbBundle.getMessage(PowerTools.class, (String)"install.feedback.NOMAC"))) {
                    GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"install.feedback.message.NOMAC")));
                    return false;
                }
                if (readCodeFromUrl.equals(NbBundle.getMessage(PowerTools.class, (String)"install.feedback.NO_NAME"))) {
                    GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"install.feedback.message.NO_NAME")));
                    return false;
                }
                if (readCodeFromUrl.equals(NbBundle.getMessage(PowerTools.class, (String)"install.feedback.WRONG_NAME"))) {
                    GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"install.feedback.message.WRONG_NAME")));
                    return false;
                }
                if (readCodeFromUrl.equals(NbBundle.getMessage(PowerTools.class, (String)"install.feedback.DATABASE_ERROR"))) {
                    GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"install.feedback.message.DATABASE_ERROR")));
                    return false;
                }
                if (readCodeFromUrl.equals(NbBundle.getMessage(PowerTools.class, (String)"install.feedback.ALREADY_INSTALLED"))) {
                    GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"install.feedback.message.ALREADY_INSTALLED")));
                    return false;
                }
                if (readCodeFromUrl.equals(NbBundle.getMessage(PowerTools.class, (String)"install.feedback.DISABLE"))) {
                    GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"install.feedback.message.DISABLE")));
                    return false;
                }
                if (readCodeFromUrl.equals(NbBundle.getMessage(PowerTools.class, (String)"install.feedback.STATUS_ERROR"))) {
                    GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"install.feedback.message.STATUS_ERROR")));
                    return false;
                }
                if (readCodeFromUrl.equals(NbBundle.getMessage(PowerTools.class, (String)"install.feedback.DONE"))) {
                    this.setCodice(pk1, pk);
                    String readCodeFromUrlOmega = this.readCodeFromUrl(this.omegaTimeUrl + "pk=" + pk);
                    String readCodeFromUrlDuration = this.readCodeFromUrl(this.durataTimeUrl + "pk=" + pk);
                    String readCodeFromUrlActivation = this.readCodeFromUrl(this.activationTimeUrl + "pk=" + pk);
                    this.setCodice(omega, readCodeFromUrlOmega);
                    this.setCodice(duration, readCodeFromUrlDuration);
                    this.setCodice(activation, readCodeFromUrlActivation);
                    long x = Math.round(1.0 * (double)new Date().getTime() / 1000.0);
                    this.setCodice(check_date, "" + x);
                    this.setCodice(durdyn, PowerTools.getPk(duration));
                    GuiAlerts.whatAMessage((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"license.done")));
                    break block15;
                }
                return false;
            }
            catch (MalformedURLException ex) {
                GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"license.servererror")));
                return false;
            }
            catch (IOException ex) {
                GuiAlerts.whatAnError((String)(this.name + " : " + NbBundle.getMessage(PowerTools.class, (String)"license.servererror")));
                return false;
            }
        }
        return true;
    }

    public void rimuoviLicenza() {
        this.comunicaRimozioneLicenza();
        this.removePK(activation);
        this.removePK(duration);
        this.removePK(omega);
        this.removePK(pk1);
        this.removePK(durdyn);
        this.removePK(check_date);
    }

    public void removePK(String pkName) {
        NbPreferences.root().remove(pkName);
    }

    public void rimuoviBlocco(String pkName) {
        NbPreferences.root().remove(pkName);
    }

    public boolean isBlocco(String pkName) {
        String get = NbPreferences.root().get(pkName, null);
        return get != null;
    }

    public void setCodice(String pkName, String value) {
        NbPreferences.root().put(pkName, value);
    }

    public static String getPk(String pkName) {
        return NbPreferences.root().get(pkName, null);
    }

    public boolean isExternalKey() {
        String property = System.getProperty("netbeans.home");
        File f = new File(property + System.getProperty("file.separator") + "c15062008");
        return f.exists();
    }

    public String readOwnerFromServer() {
        String pk = PowerTools.getPk(pk1);
        try {
            return this.readCodeFromUrl(this.ownerUrl + "pk=" + pk);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    public void comunicaRimozioneLicenza() {
        try {
            this.readCodeFromUrl(this.removedUrl + "pk=" + PowerTools.getPk(pk1));
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isLicenzaIntegra() {
        String pk = PowerTools.getPk(pk1);
        if (pk == null || pk.equals("")) {
            return false;
        }
        return PowerTools.isLicenzaInstallataConforme();
    }

    public static boolean isLicenzaInstallataConforme() {
        String pk = PowerTools.getPk(pk1);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update((pk + PowerTools.getID()).getBytes());
            BigInteger hash = new BigInteger(1, md.digest());
            String xxx = hash.toString(16);
            String string = "" + xxx.substring(10, 11) + xxx.substring(5, 6) + xxx.substring(2, 3) + xxx.substring(6, 7) + xxx.substring(13, 14) + xxx.substring(11, 12) + xxx.substring(9, 10) + xxx.substring(8, 9);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
        return true;
    }

    public static boolean checksumPK(String pk) {
        try {
            if (pk.length() != 10) {
                return false;
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(pk.substring(0, 8).getBytes());
            BigInteger hash = new BigInteger(1, md.digest());
            String xxx = hash.toString(16);
            if (xxx.substring(10, 11).equals(pk.substring(8, 9)) && xxx.substring(20, 21).equals(pk.substring(9, 10))) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private String comprimiUnCodice(String source) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(source.getBytes());
            BigInteger hash = new BigInteger(1, md.digest());
            String xxx = hash.toString(16);
            String substring = xxx.substring(7, 12);
            return substring;
        }
        catch (NoSuchAlgorithmException ex) {
            return "" + Math.random();
        }
    }

    public static String getHostNameFromLinux() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            return "Errore!!!";
        }
    }

    public static String getHostNameFromWindows() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            return "Errore!!!";
        }
    }

    private String readCodeFromUrl(String url) throws MalformedURLException, IOException {
        URL oracle = new URL(url);
        BufferedReader in = new BufferedReader(new InputStreamReader(oracle.openStream()));
        String inputLine = in.readLine();
        if (inputLine != null) {
            in.close();
            return inputLine;
        }
        return "";
    }

    public static String getID() {
        if (OSValidator.isMac() || OSValidator.isUnix() || OSValidator.isSolaris()) {
            return PowerTools.getHostNameFromLinux();
        }
        if (OSValidator.isWindows()) {
            return PowerTools.getHostNameFromWindows();
        }
        return "sconosciuto";
    }

    public static void powering() {
    }
}

