/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.analysis.variables;

import formattazione.numeri.MyNumberFormatter;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.functionsapi.IApplicationManager;

public abstract class AModelVariableStatisticBuilder {
    private int amountOfStudy;
    private int amountOfOutcomebranch;
    private final IApplicationManager applicationEventWorker;
    private final long topicId;
    protected MyNumberFormatter myNumberFormatter = TuliTuliTools.generateMyNumberFormatter();

    public AModelVariableStatisticBuilder(long topicId, IApplicationManager applicationEventWorker) {
        this.applicationEventWorker = applicationEventWorker;
        this.topicId = topicId;
        this.amountOfStudy = applicationEventWorker.getIDataFunction().getAllStudiesOfTopic(topicId).size();
        this.amountOfOutcomebranch = applicationEventWorker.getIDataFunction().getAllOutcomebranchsOfTopic(topicId).size();
    }

    public long getTopicId() {
        return this.topicId;
    }

    public void refresh() {
        this.amountOfStudy = this.applicationEventWorker.getIDataFunction().getAllStudiesOfTopic(this.topicId).size();
        this.amountOfOutcomebranch = this.applicationEventWorker.getIDataFunction().getAllOutcomebranchsOfTopic(this.topicId).size();
    }

    public int getAmountOfOutcomebranch() {
        return this.amountOfOutcomebranch;
    }

    public int getAmountOfStudy() {
        return this.amountOfStudy;
    }

    public IApplicationManager getApplicationEventWorker() {
        return this.applicationEventWorker;
    }
}

