/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.analysis.variables;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import metaanalysis.analysis.variables.AModelVariableStatisticBuilder;
import metaanalysis.analysis.variables.ComparisonSingleVariableBuilder;
import metaanalysis.analysis.variables.IVariablesStatisticReport;
import metaanalysis.analysis.variables.ModelVariableInstanceReport;
import metaanalysis.analysis.variables.ModelVariableStatistic;
import metaanalysis.analysis.variables.TableModelVariableReport;
import metaanalysis.analysis.variables.TableVariableReport;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.functionsapi.DatabaseTreeNullException;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Comparison;
import metaanalysis.models.tables.TableFunctions;
import org.openide.util.NbBundle;

public class ComparisonModelVariableStatisticBuilder
extends AModelVariableStatisticBuilder
implements IVariablesStatisticReport {
    List<Comparison> comparisons;
    ModelVariableStatistic modelVariableStatistic;

    public ComparisonModelVariableStatisticBuilder(long topicId, IApplicationManager applicationEventWorker) {
        super(topicId, applicationEventWorker);
        this.refresh();
    }

    @Override
    public ModelVariableStatistic getModelVariableStatistic() {
        return this.modelVariableStatistic;
    }

    @Override
    public TableVariableReport getTable() {
        TableVariableReport tableVariableReport = new TableVariableReport(new TableModelVariableReport(this.modelVariableStatistic, this.myNumberFormatter));
        TableFunctions.showToolTips((JTable)((Object)tableVariableReport));
        return tableVariableReport;
    }

    @Override
    public final void refresh() {
        super.refresh();
        this.comparisons = this.getApplicationEventWorker().getIDataFunction().getAllComparisonsOfTopic(this.getTopicId());
        ArrayList<ModelVariableInstanceReport> variableInstances = new ArrayList<ModelVariableInstanceReport>();
        for (Comparison x : this.comparisons) {
            try {
                variableInstances.add(new ComparisonSingleVariableBuilder(x, this.getApplicationEventWorker()).buildModelVariableInstanceReport());
            }
            catch (DatabaseTreeNullException ex) {
                TuliTuliTools.whatAnError((String)NbBundle.getMessage(ComparisonModelVariableStatisticBuilder.class, (String)"error.incompleteTree", (Object)x.getName()));
            }
        }
        this.modelVariableStatistic = new ModelVariableStatistic(NbBundle.getMessage(TableModelVariableReport.class, (String)"variables.analysis.comparison.name"), this.getAmountOfStudy(), this.getAmountOfOutcomebranch(), variableInstances);
    }
}

