/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.analysis.variables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import metaanalysis.analysis.variables.ASingleVariableController;
import metaanalysis.analysis.variables.DatabaseFunctions;
import metaanalysis.analysis.variables.ModelMissingReport;
import metaanalysis.analysis.variables.ModelVariableInstanceReport;
import metaanalysis.core.entitycomparators.StudyNameComparator;
import metaanalysis.core.functionsapi.DatabaseTreeNullException;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Comparison;
import metaanalysis.core.persistence.Comparisonbranch;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.tools.DatabaseRowCompleteName;

public class ComparisonSingleVariableBuilder
extends ASingleVariableController {
    private Comparison comparison;

    public ComparisonSingleVariableBuilder(Comparison comparison, IApplicationManager applicationEventWorker) {
        super(applicationEventWorker);
        this.comparison = comparison;
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    @Override
    public ModelVariableInstanceReport buildModelVariableInstanceReport() throws DatabaseTreeNullException {
        List allComparisonbranchsOfComparison = this.getApplicationEventWorker().getIDataFunction().getAllComparisonbranchsOfComparison(this.comparison);
        int n_es = 0;
        for (Comparisonbranch cb : allComparisonbranchsOfComparison) {
            n_es += this.getApplicationEventWorker().getIDataFunction().getAllOutcomebranchsOfComparisonbranch(cb.getId()).size();
        }
        ModelMissingReport missing = new ModelMissingReport();
        ArrayList<Long> studiesIds = new ArrayList<Long>();
        ArrayList<Study> studies = new ArrayList<Study>();
        for (Comparisonbranch xxx : allComparisonbranchsOfComparison) {
            Study s = this.getApplicationEventWorker().getIDataFunction().getStudyOfComparisonbranch(xxx.getId());
            if (!studiesIds.contains(s.getId())) {
                studiesIds.add(s.getId());
                studies.add(s);
            }
            List<DatabaseRowCompleteName> findComparisonbranchMissingLocations = DatabaseFunctions.findComparisonbranchMissingLocations(xxx, this.getApplicationEventWorker());
            for (DatabaseRowCompleteName tmp : findComparisonbranchMissingLocations) {
                if (tmp.getOutcomeName() == null && tmp.getTimepointId() == null) {
                    tmp.setComparisonName(null);
                }
                missing.addError(tmp.getCompositeName());
            }
        }
        Collections.sort(studies, new StudyNameComparator());
        return new ModelVariableInstanceReport(this.comparison.getName(), studies, n_es, missing);
    }
}

