/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.analysis.variables;

import java.util.ArrayList;
import java.util.List;
import metaanalysis.core.functionsapi.DatabaseTreeNullException;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Comparisonbranch;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Subgroupbranch;
import metaanalysis.core.persistence.Timepointbranch;
import metaanalysis.core.tools.DatabaseRowCompleteName;

public class DatabaseFunctions {
    public static DatabaseRowCompleteName findOutcomebranchMissingLocations(Outcomebranch outcomebranch, IApplicationManager applicationEventWorker) throws DatabaseTreeNullException {
        if (outcomebranch.getEffectsizevalue() == null) {
            return applicationEventWorker.getIDataFunction().getOutcomebranchCompleteName(outcomebranch);
        }
        return null;
    }

    public static DatabaseRowCompleteName findOutcomebranchMissingLocations(Long outcomebranchId, IApplicationManager applicationEventWorker) throws DatabaseTreeNullException {
        Outcomebranch outcomebranch = applicationEventWorker.getIDataFunction().getOutcomebranch(outcomebranchId.longValue());
        return DatabaseFunctions.findOutcomebranchMissingLocations(outcomebranch, applicationEventWorker);
    }

    public static List<DatabaseRowCompleteName> findTimepointbranchMissingLocations(Timepointbranch timepointbranch, IApplicationManager applicationEventWorker) throws DatabaseTreeNullException {
        ArrayList<DatabaseRowCompleteName> ret = new ArrayList<DatabaseRowCompleteName>();
        List allOutcomebranchsOfTimepointbranch = applicationEventWorker.getIDataFunction().getAllOutcomebranchsOfTimepointbranch(timepointbranch);
        DatabaseRowCompleteName timepointbranchCompleteName = applicationEventWorker.getIDataFunction().getTimepointbranchCompleteName(timepointbranch);
        if (allOutcomebranchsOfTimepointbranch.isEmpty()) {
            ret.add(timepointbranchCompleteName);
        } else {
            for (Outcomebranch o : allOutcomebranchsOfTimepointbranch) {
                DatabaseRowCompleteName error = null;
                try {
                    error = DatabaseFunctions.findOutcomebranchMissingLocations(o, applicationEventWorker);
                }
                catch (DatabaseTreeNullException ex) {
                    ret.add(timepointbranchCompleteName);
                }
                if (error == null) continue;
                ret.add(error);
            }
        }
        return ret;
    }

    public static List<DatabaseRowCompleteName> findTimepointbranchMissingLocations(long timepointbranchId, IApplicationManager applicationEventWorker) throws DatabaseTreeNullException {
        Timepointbranch timepointbranch = applicationEventWorker.getIDataFunction().getTimepointbranch(timepointbranchId);
        return DatabaseFunctions.findTimepointbranchMissingLocations(timepointbranch, applicationEventWorker);
    }

    public static List<DatabaseRowCompleteName> findComparisonbranchMissingLocations(Comparisonbranch comparisonbranch, IApplicationManager applicationEventWorker) throws DatabaseTreeNullException {
        ArrayList<DatabaseRowCompleteName> ret = new ArrayList<DatabaseRowCompleteName>();
        List allTB = applicationEventWorker.getIDataFunction().getAllTimepointbranchesOfComparisonbranch(comparisonbranch);
        DatabaseRowCompleteName comparisonbranchCompleteName = applicationEventWorker.getIDataFunction().getComparisonbranchCompleteName(comparisonbranch);
        if (allTB.isEmpty()) {
            ret.add(comparisonbranchCompleteName);
        } else {
            for (Timepointbranch x : allTB) {
                List<DatabaseRowCompleteName> errors = null;
                try {
                    errors = DatabaseFunctions.findTimepointbranchMissingLocations(x, applicationEventWorker);
                }
                catch (DatabaseTreeNullException ex) {
                    ret.add(comparisonbranchCompleteName);
                }
                if (errors.isEmpty()) continue;
                ret.addAll(errors);
            }
        }
        return ret;
    }

    public static List<DatabaseRowCompleteName> findComparisonbranchMissingLocations(long comparisonbranchId, IApplicationManager applicationEventWorker) throws DatabaseTreeNullException {
        Comparisonbranch comparisonbranch = applicationEventWorker.getIDataFunction().getComparisonbranch(comparisonbranchId);
        return DatabaseFunctions.findComparisonbranchMissingLocations(comparisonbranch, applicationEventWorker);
    }

    public static List<DatabaseRowCompleteName> findSubgroupbranchMissingLocations(Subgroupbranch subgroupbranch, IApplicationManager applicationEventWorker) throws DatabaseTreeNullException {
        ArrayList<DatabaseRowCompleteName> ret = new ArrayList<DatabaseRowCompleteName>();
        List allCB = applicationEventWorker.getIDataFunction().getAllComparisonbranchesOfSubgroupbranch(subgroupbranch);
        DatabaseRowCompleteName subgroupbranchCompleteName = applicationEventWorker.getIDataFunction().getSubgroupbranchCompleteName(subgroupbranch);
        if (allCB.isEmpty()) {
            ret.add(subgroupbranchCompleteName);
        } else {
            for (Comparisonbranch x : allCB) {
                List<DatabaseRowCompleteName> errors = null;
                try {
                    errors = DatabaseFunctions.findComparisonbranchMissingLocations(x, applicationEventWorker);
                }
                catch (DatabaseTreeNullException ex) {
                    ret.add(subgroupbranchCompleteName);
                }
                if (errors.isEmpty()) continue;
                ret.addAll(errors);
            }
        }
        return ret;
    }

    public static List<DatabaseRowCompleteName> findSubgroupbranchMissingLocations(long subgroupbranchId, IApplicationManager applicationEventWorker) throws DatabaseTreeNullException {
        Subgroupbranch subgroupbranch = applicationEventWorker.getIDataFunction().getSubgroupbranch(subgroupbranchId);
        return DatabaseFunctions.findSubgroupbranchMissingLocations(subgroupbranch, applicationEventWorker);
    }

    public static List<DatabaseRowCompleteName> findStudyMissingLocations(Study study, IApplicationManager applicationEventWorker) {
        ArrayList<DatabaseRowCompleteName> ret = new ArrayList<DatabaseRowCompleteName>();
        List allSB = applicationEventWorker.getIDataFunction().getAllSubgroupbranchesOfStudy(study.getId());
        DatabaseRowCompleteName databaseRowCompleteName = new DatabaseRowCompleteName(study.getName());
        if (allSB.isEmpty()) {
            ret.add(databaseRowCompleteName);
        } else {
            for (Subgroupbranch x : allSB) {
                List<DatabaseRowCompleteName> errors = null;
                try {
                    errors = DatabaseFunctions.findSubgroupbranchMissingLocations(x, applicationEventWorker);
                }
                catch (DatabaseTreeNullException ex) {
                    ret.add(databaseRowCompleteName);
                }
                if (errors.isEmpty()) continue;
                ret.addAll(errors);
            }
        }
        return ret;
    }

    public static List<DatabaseRowCompleteName> findStudyMissingLocations(long studyId, IApplicationManager applicationEventWorker) {
        Study s = applicationEventWorker.getIDataFunction().getStudy(studyId);
        return DatabaseFunctions.findStudyMissingLocations(s, applicationEventWorker);
    }
}

