/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.analysis.variables;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openide.util.NbBundle;

public class ModelMissingReport {
    public static int error = 1;
    public static int warning = 2;
    private Map<String, Integer> missingData = new HashMap<String, Integer>();

    public Map<String, Integer> getMissingData() {
        return this.missingData;
    }

    public void setMissingData(Map<String, Integer> missingData) {
        this.missingData = missingData;
    }

    public void addWarning(String warningLabel) {
        this.missingData.put(warningLabel, warning);
    }

    public void addError(String errorLabel) {
        this.missingData.put(errorLabel, error);
    }

    public List<String> getAllWarningsLabels() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String s : this.missingData.keySet()) {
            if (this.missingData.get(s) != warning) continue;
            ret.add(s);
        }
        return ret;
    }

    public List<String> getAllErrorsLabels() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String s : this.missingData.keySet()) {
            if (this.missingData.get(s) != error) continue;
            ret.add(s);
        }
        return ret;
    }

    public String toString() {
        if (this.getAllErrorsLabels().size() + this.getAllWarningsLabels().size() == 0) {
            return NbBundle.getMessage(ModelMissingReport.class, (String)"labels.nomissingdata");
        }
        String ret = "<html>";
        String intro = "";
        for (String s : this.getAllErrorsLabels()) {
            ret = ret + intro + NbBundle.getMessage(ModelMissingReport.class, (String)"labels.error") + " " + s;
            intro = "<br/>";
        }
        for (String s : this.getAllWarningsLabels()) {
            ret = ret + intro + NbBundle.getMessage(ModelMissingReport.class, (String)"labels.warning") + " " + s;
            intro = "<br/>";
        }
        return ret + "</html>";
    }
}

