/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.analysis.variables;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import metaanalysis.analysis.variables.AModelVariableStatisticBuilder;
import metaanalysis.analysis.variables.IVariablesStatisticReport;
import metaanalysis.analysis.variables.ModelVariableInstanceReport;
import metaanalysis.analysis.variables.ModelVariableStatistic;
import metaanalysis.analysis.variables.OutcomeSingleVariableBuilder;
import metaanalysis.analysis.variables.TableModelVariableReport;
import metaanalysis.analysis.variables.TableVariableReport;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.functionsapi.DatabaseTreeNullException;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.models.tables.TableFunctions;
import org.openide.util.NbBundle;

public class OutcomeModelVariableStatisticBuilder
extends AModelVariableStatisticBuilder
implements IVariablesStatisticReport {
    List<Outcome> outcomes;
    ModelVariableStatistic modelVariableStatistic;

    public OutcomeModelVariableStatisticBuilder(long topicId, IApplicationManager applicationEventWorker) {
        super(topicId, applicationEventWorker);
        this.refresh();
    }

    @Override
    public ModelVariableStatistic getModelVariableStatistic() {
        return this.modelVariableStatistic;
    }

    @Override
    public TableVariableReport getTable() {
        TableVariableReport tableVariableReport = new TableVariableReport(new TableModelVariableReport(this.modelVariableStatistic, this.myNumberFormatter));
        TableFunctions.showToolTips((JTable)((Object)tableVariableReport));
        return tableVariableReport;
    }

    @Override
    public final void refresh() {
        super.refresh();
        this.outcomes = this.getApplicationEventWorker().getIDataFunction().getAllOutcomesOfTopic(this.getTopicId());
        ArrayList<ModelVariableInstanceReport> variableInstances = new ArrayList<ModelVariableInstanceReport>();
        for (Outcome o : this.outcomes) {
            try {
                variableInstances.add(new OutcomeSingleVariableBuilder(o, this.getApplicationEventWorker()).buildModelVariableInstanceReport());
            }
            catch (DatabaseTreeNullException ex) {
                TuliTuliTools.whatAnError((String)NbBundle.getMessage(OutcomeModelVariableStatisticBuilder.class, (String)"error.incompleteTree", (Object)o.getName()));
            }
        }
        this.modelVariableStatistic = new ModelVariableStatistic(NbBundle.getMessage(TableModelVariableReport.class, (String)"variables.analysis.outcome.name"), this.getAmountOfStudy(), this.getAmountOfOutcomebranch(), variableInstances);
    }
}

