/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.analysis.variables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import metaanalysis.analysis.variables.ASingleVariableController;
import metaanalysis.analysis.variables.DatabaseFunctions;
import metaanalysis.analysis.variables.ModelMissingReport;
import metaanalysis.analysis.variables.ModelVariableInstanceReport;
import metaanalysis.core.entitycomparators.StudyNameComparator;
import metaanalysis.core.functionsapi.DatabaseTreeNullException;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.tools.DatabaseRowCompleteName;

public class OutcomeSingleVariableBuilder
extends ASingleVariableController {
    private Outcome outcome;

    public OutcomeSingleVariableBuilder(Outcome outcome, IApplicationManager applicationEventWorker) {
        super(applicationEventWorker);
        this.outcome = outcome;
    }

    public Outcome getOutcome() {
        return this.outcome;
    }

    @Override
    public ModelVariableInstanceReport buildModelVariableInstanceReport() throws DatabaseTreeNullException {
        List allOutcomebranchsOfOutcome = this.getApplicationEventWorker().getIDataFunction().getAllOutcomebranchsOfOutcome(this.outcome);
        ModelMissingReport missing = new ModelMissingReport();
        ArrayList<Long> studiesIds = new ArrayList<Long>();
        ArrayList<Study> studies = new ArrayList<Study>();
        for (Outcomebranch ob : allOutcomebranchsOfOutcome) {
            DatabaseRowCompleteName location;
            long studyId = this.getApplicationEventWorker().getIDataFunction().getStudyOfOutcomebranch(ob.getId()).getId();
            if (!studiesIds.contains(studyId)) {
                studiesIds.add(studyId);
                studies.add(this.getApplicationEventWorker().getIDataFunction().getStudy(studyId));
            }
            if ((location = DatabaseFunctions.findOutcomebranchMissingLocations(ob, this.getApplicationEventWorker())) == null) continue;
            location.setOutcomeName(null);
            missing.addError(location.getCompositeName());
        }
        Collections.sort(studies, new StudyNameComparator());
        return new ModelVariableInstanceReport(this.outcome.getName(), studies, allOutcomebranchsOfOutcome.size(), missing);
    }
}

