/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.analysis.variables;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import metaanalysis.analysis.variables.AModelVariableStatisticBuilder;
import metaanalysis.analysis.variables.IVariablesStatisticReport;
import metaanalysis.analysis.variables.ModelVariableInstanceReport;
import metaanalysis.analysis.variables.ModelVariableStatistic;
import metaanalysis.analysis.variables.StudySingleVariableBuilder;
import metaanalysis.analysis.variables.TableModelStudiesReport;
import metaanalysis.analysis.variables.TableModelVariableReport;
import metaanalysis.analysis.variables.TableStudiesReport;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Study;
import metaanalysis.models.tables.TableFunctions;
import org.openide.util.NbBundle;

public class StudyModelVariableStatisticBuilder
extends AModelVariableStatisticBuilder
implements IVariablesStatisticReport {
    List<Study> studies;
    ModelVariableStatistic modelVariableStatistic;

    public StudyModelVariableStatisticBuilder(long topicId, IApplicationManager applicationEventWorker) {
        super(topicId, applicationEventWorker);
        this.refresh();
    }

    @Override
    public ModelVariableStatistic getModelVariableStatistic() {
        return this.modelVariableStatistic;
    }

    @Override
    public TableStudiesReport getTable() {
        TableStudiesReport table = new TableStudiesReport(new TableModelStudiesReport(this.modelVariableStatistic));
        TableFunctions.showToolTips((JTable)((Object)table));
        return table;
    }

    @Override
    public final void refresh() {
        super.refresh();
        this.studies = this.getApplicationEventWorker().getIDataFunction().getAllStudiesOfTopic(this.getTopicId());
        ArrayList<ModelVariableInstanceReport> variableInstances = new ArrayList<ModelVariableInstanceReport>();
        for (Study x : this.studies) {
            variableInstances.add(new StudySingleVariableBuilder(x, this.getApplicationEventWorker()).buildModelVariableInstanceReport());
        }
        this.modelVariableStatistic = new ModelVariableStatistic(NbBundle.getMessage(TableModelVariableReport.class, (String)"variables.analysis.study.name"), this.getAmountOfStudy(), this.getAmountOfOutcomebranch(), variableInstances);
    }
}

