/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.analysis.variables;

import java.util.List;
import metaanalysis.analysis.variables.ASingleVariableController;
import metaanalysis.analysis.variables.DatabaseFunctions;
import metaanalysis.analysis.variables.ModelMissingReport;
import metaanalysis.analysis.variables.ModelVariableInstanceReport;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.tools.DatabaseRowCompleteName;

public class StudySingleVariableBuilder
extends ASingleVariableController {
    private Study study;

    public StudySingleVariableBuilder(Study study, IApplicationManager applicationEventWorker) {
        super(applicationEventWorker);
        this.study = study;
    }

    public Study getStudy() {
        return this.study;
    }

    @Override
    public ModelVariableInstanceReport buildModelVariableInstanceReport() {
        List<DatabaseRowCompleteName> locations = DatabaseFunctions.findStudyMissingLocations(this.study, this.getApplicationEventWorker());
        List allOutcomebranchsOfStudy = this.getApplicationEventWorker().getIDataFunction().getAllOutcomebranchsOfStudy(this.study.getId());
        ModelMissingReport missing = new ModelMissingReport();
        for (DatabaseRowCompleteName d : locations) {
            missing.addError(d.getCompositeName());
        }
        return new ModelVariableInstanceReport(this.study.getName(), null, allOutcomebranchsOfStudy.size(), missing);
    }
}

