/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.analysis.variables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import metaanalysis.analysis.variables.ASingleVariableController;
import metaanalysis.analysis.variables.DatabaseFunctions;
import metaanalysis.analysis.variables.ModelMissingReport;
import metaanalysis.analysis.variables.ModelVariableInstanceReport;
import metaanalysis.core.entitycomparators.StudyNameComparator;
import metaanalysis.core.functionsapi.DatabaseTreeNullException;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Subgroup;
import metaanalysis.core.persistence.Subgroupbranch;
import metaanalysis.core.tools.DatabaseRowCompleteName;

public class SubgroupSingleVariableBuilder
extends ASingleVariableController {
    private Subgroup subgroup;

    public SubgroupSingleVariableBuilder(Subgroup subgroup, IApplicationManager applicationEventWorker) {
        super(applicationEventWorker);
        this.subgroup = subgroup;
    }

    public Subgroup getSubgroup() {
        return this.subgroup;
    }

    @Override
    public ModelVariableInstanceReport buildModelVariableInstanceReport() throws DatabaseTreeNullException {
        List allSubgroupbranchesOfSubgroup = this.getApplicationEventWorker().getIDataFunction().getAllSubgroupbranchesOfSubgroup(this.subgroup);
        int n_es = 0;
        for (Subgroupbranch cb : allSubgroupbranchesOfSubgroup) {
            n_es += this.getApplicationEventWorker().getIDataFunction().getAllOutcomebranchsOfSubgroupbranch(cb.getId()).size();
        }
        ModelMissingReport missing = new ModelMissingReport();
        ArrayList<Long> studiesIds = new ArrayList<Long>();
        ArrayList<Study> studies = new ArrayList<Study>();
        for (Subgroupbranch sbb : allSubgroupbranchesOfSubgroup) {
            Study s = this.getApplicationEventWorker().getIDataFunction().getStudy(sbb.getStudyId().longValue());
            if (!studiesIds.contains(s.getId())) {
                studiesIds.add(s.getId());
                studies.add(s);
            }
            List<DatabaseRowCompleteName> findSubgroupbranchMissingLocations = DatabaseFunctions.findSubgroupbranchMissingLocations(sbb, this.getApplicationEventWorker());
            for (DatabaseRowCompleteName tmp : findSubgroupbranchMissingLocations) {
                if (tmp.getOutcomeName() == null && tmp.getTimepointId() == null && tmp.getComparisonName() == null) {
                    tmp.setSubgroupName(null);
                }
                missing.addError(tmp.getCompositeName());
            }
        }
        Collections.sort(studies, new StudyNameComparator());
        return new ModelVariableInstanceReport(this.subgroup.getName(), studies, n_es, missing);
    }
}

