/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.analysis.variables;

import java.util.ArrayList;
import javax.swing.JTable;
import metaanalysis.analysis.variables.AModelVariableStatisticBuilder;
import metaanalysis.analysis.variables.IVariablesStatisticReport;
import metaanalysis.analysis.variables.ModelVariableInstanceReport;
import metaanalysis.analysis.variables.ModelVariableStatistic;
import metaanalysis.analysis.variables.SubgroupModelVariableStatisticBuilder;
import metaanalysis.analysis.variables.TableModelVariableReport;
import metaanalysis.analysis.variables.TableVariableReport;
import metaanalysis.analysis.variables.TimepointSingleVariableBuilder;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.functionsapi.DatabaseTreeNullException;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.models.tables.TableFunctions;
import org.openide.util.NbBundle;

public class TimepointModelVariableStatisticBuilder
extends AModelVariableStatisticBuilder
implements IVariablesStatisticReport {
    int timepoints;
    ModelVariableStatistic modelVariableStatistic;

    public TimepointModelVariableStatisticBuilder(long topicId, IApplicationManager applicationEventWorker) {
        super(topicId, applicationEventWorker);
        this.refresh();
    }

    @Override
    public ModelVariableStatistic getModelVariableStatistic() {
        return this.modelVariableStatistic;
    }

    @Override
    public TableVariableReport getTable() {
        TableVariableReport tableVariableReport = new TableVariableReport(new TableModelVariableReport(this.modelVariableStatistic, this.myNumberFormatter));
        TableFunctions.showToolTips((JTable)((Object)tableVariableReport));
        return tableVariableReport;
    }

    @Override
    public final void refresh() {
        super.refresh();
        this.timepoints = this.getApplicationEventWorker().getIDataFunction().getMaxTimepointOfTopic(this.getTopicId());
        ArrayList<ModelVariableInstanceReport> variableInstances = new ArrayList<ModelVariableInstanceReport>();
        if (this.timepoints > 0) {
            for (int i = 0; i <= this.timepoints; ++i) {
                try {
                    variableInstances.add(new TimepointSingleVariableBuilder(this.getTopicId(), i, this.getApplicationEventWorker()).buildModelVariableInstanceReport());
                    continue;
                }
                catch (DatabaseTreeNullException ex) {
                    TuliTuliTools.whatAnError((String)NbBundle.getMessage(SubgroupModelVariableStatisticBuilder.class, (String)"error.incompleteTree", (Object)("W" + (i + 1))));
                }
            }
        }
        this.modelVariableStatistic = new ModelVariableStatistic(NbBundle.getMessage(TableModelVariableReport.class, (String)"variables.analysis.timepoint.name"), this.getAmountOfStudy(), this.getAmountOfOutcomebranch(), variableInstances);
    }
}

