/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.analysis.variables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import metaanalysis.analysis.variables.ASingleVariableController;
import metaanalysis.analysis.variables.DatabaseFunctions;
import metaanalysis.analysis.variables.ModelMissingReport;
import metaanalysis.analysis.variables.ModelVariableInstanceReport;
import metaanalysis.core.entitycomparators.StudyNameComparator;
import metaanalysis.core.functionsapi.DatabaseTreeNullException;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Timepointbranch;
import metaanalysis.core.tools.DatabaseRowCompleteName;

public class TimepointSingleVariableBuilder
extends ASingleVariableController {
    private long topicId;
    private int timepoint;

    public TimepointSingleVariableBuilder(long topicId, int timepoint, IApplicationManager applicationEventWorker) {
        super(applicationEventWorker);
        this.timepoint = timepoint;
        this.topicId = topicId;
    }

    public long getTopicId() {
        return this.topicId;
    }

    public int getTimepoint() {
        return this.timepoint;
    }

    @Override
    public ModelVariableInstanceReport buildModelVariableInstanceReport() throws DatabaseTreeNullException {
        List allTimepointbranchesOfTopic = this.getApplicationEventWorker().getIDataFunction().getAllTimepointbranchesOfTopic(this.topicId, this.timepoint);
        int n_es = 0;
        for (Timepointbranch tb : allTimepointbranchesOfTopic) {
            n_es += this.getApplicationEventWorker().getIDataFunction().getAllOutcomebranchsOfTimepointbranch(tb.getId()).size();
        }
        ModelMissingReport missing = new ModelMissingReport();
        ArrayList<Long> studiesIds = new ArrayList<Long>();
        ArrayList<Study> studies = new ArrayList<Study>();
        for (Timepointbranch xxx : allTimepointbranchesOfTopic) {
            Study s = this.getApplicationEventWorker().getIDataFunction().getStudyOfTimepointbranch(xxx.getId());
            if (!studiesIds.contains(s.getId())) {
                studiesIds.add(s.getId());
                studies.add(s);
            }
            List<DatabaseRowCompleteName> findTimepointbranchMissingLocations = DatabaseFunctions.findTimepointbranchMissingLocations(xxx, this.getApplicationEventWorker());
            for (DatabaseRowCompleteName tmp : findTimepointbranchMissingLocations) {
                if (tmp.getOutcomeName() == null) {
                    tmp.setTimepointId(null);
                }
                missing.addError(tmp.getCompositeName());
            }
        }
        Collections.sort(studies, new StudyNameComparator());
        return new ModelVariableInstanceReport("W" + (this.timepoint + 1), studies, n_es, missing);
    }
}

