/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.analysis.models;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import metaanalysis.effectsizes.models.ESRConversions;
import metaanalysis.effectsizes.models.IEffectSizeResults;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import org.openide.util.NbBundle;

public class AnalysisFilter
implements Serializable {
    public static final String[] tSquareType = new String[]{"Do not combine T\u00b2", "Combine T\u00b2"};
    public static final int separateTSquare = 0;
    public static final int aggregateTSquare = 1;
    public static final String nullValue = "* Not available";
    protected Map<Integer, Integer> categoricalTSquareType = new HashMap<Integer, Integer>();
    protected Map<Long, Integer> recodedTSquareType = new HashMap<Long, Integer>();
    protected String effectSizeType = NbBundle.getMessage(IEffectSizeValue.class, (String)"cohensDLabel");
    protected boolean randomMode = true;
    protected boolean fixedMode = false;
    protected boolean combineComparisons = false;
    protected boolean combineTimepoints = false;
    protected boolean combineOutcomes = false;
    protected boolean combineSubgroups = false;
    protected Map<Long, List<String>> recodedModeratorsExcludedValues = new HashMap<Long, List<String>>();
    protected Map<Integer, List<String>> categoricalModeratorsExcludedValues = new HashMap<Integer, List<String>>();
    protected List<Long> excludedStudies = new ArrayList<Long>();
    protected List<Integer> excludedModerators = new ArrayList<Integer>();
    protected List<Long> excludedRecodedModerators = new ArrayList<Long>();
    protected List<Integer> excludedComparisons = new ArrayList<Integer>();
    protected List<Integer> excludedSubgroups = new ArrayList<Integer>();
    protected List<Integer> excludedTimepoints = new ArrayList<Integer>();
    protected List<Integer> excludedOutcomes = new ArrayList<Integer>();
    protected double correlationBetweenOutcomes = 0.5;
    protected double correlationBetweenTimepoints = 0.5;
    protected double confidenceInterval = 1.95996398;
    public static int leftSideSearch = 0;
    public static int rightSideSearch = 1;
    private int publicationBiasSearch = 0;

    public Map<Integer, Integer> getCategoricalTSquareType() {
        return this.categoricalTSquareType;
    }

    public void setCategoricalTSquareType(Map<Integer, Integer> categoricalTSquareType) {
        this.categoricalTSquareType = categoricalTSquareType;
    }

    public Map<Long, Integer> getRecodedTSquareType() {
        return this.recodedTSquareType;
    }

    public void setRecodedTSquareType(Map<Long, Integer> recodedTSquareType) {
        this.recodedTSquareType = recodedTSquareType;
    }

    public String getEffectSizeType() {
        return this.effectSizeType;
    }

    public String getPressEffectSizeType() {
        return this.getEffectSizeType();
    }

    public void setEffectSizeType(String effectSizeType) {
        this.effectSizeType = effectSizeType;
    }

    public String getCalculationEffectSizeType() {
        return AnalysisFilter.findCalculationEffectSizeType(this.getPressEffectSizeType());
    }

    public static String findCalculationEffectSizeType(String pressEffectSizeType) {
        if (pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oddsRatioLabel"))) {
            return NbBundle.getMessage(IEffectSizeValue.class, (String)"logOddsRatioLabel");
        }
        if (pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"correlationLabel"))) {
            return NbBundle.getMessage(IEffectSizeValue.class, (String)"fishersZLabel");
        }
        if (pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"hazardRatioLabel"))) {
            return NbBundle.getMessage(IEffectSizeValue.class, (String)"logHazardRatioLabel");
        }
        if (pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"riskRatioLabel"))) {
            return NbBundle.getMessage(IEffectSizeValue.class, (String)"logRiskRatioLabel");
        }
        if (pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"petoOddsRatioLabel"))) {
            return NbBundle.getMessage(IEffectSizeValue.class, (String)"logPetoOddsRatioLabel");
        }
        if (pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"rateRatioLabel"))) {
            return NbBundle.getMessage(IEffectSizeValue.class, (String)"logRateRatioLabel");
        }
        if (pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.eventRate"))) {
            return NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.logEventRate");
        }
        return pressEffectSizeType;
    }

    public static IEffectSizeResults doLastConversion(IEffectSizeResults sourceCalculatedEffectSize, String effectSizeType, double confidenceInterval) {
        if (effectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oddsRatioLabel"))) {
            return ESRConversions.fromLogOddsRatioToOddsRatio((IEffectSizeResults)sourceCalculatedEffectSize, (double)confidenceInterval);
        }
        if (effectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"correlationLabel"))) {
            return ESRConversions.fromFisherZToCorrelation((IEffectSizeResults)sourceCalculatedEffectSize, (double)confidenceInterval);
        }
        if (effectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"hazardRatioLabel"))) {
            return ESRConversions.convertFromLogToNormal((IEffectSizeResults)sourceCalculatedEffectSize);
        }
        if (effectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"riskRatioLabel"))) {
            return ESRConversions.convertFromLogToNormal((IEffectSizeResults)sourceCalculatedEffectSize);
        }
        if (effectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"petoOddsRatioLabel"))) {
            return ESRConversions.convertFromLogToNormal((IEffectSizeResults)sourceCalculatedEffectSize);
        }
        if (effectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"rateRatioLabel"))) {
            return ESRConversions.convertFromLogToNormal((IEffectSizeResults)sourceCalculatedEffectSize);
        }
        if (effectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.eventRate"))) {
            return ESRConversions.convertFromLogToNormal((IEffectSizeResults)sourceCalculatedEffectSize);
        }
        return sourceCalculatedEffectSize;
    }

    public boolean isRandomMode() {
        return this.randomMode;
    }

    public void setRandomMode(boolean randomMode) {
        this.randomMode = randomMode;
    }

    public boolean isFixedMode() {
        return this.fixedMode;
    }

    public void setFixedMode(boolean fixedMode) {
        this.fixedMode = fixedMode;
    }

    public boolean isCombineComparisons() {
        return this.combineComparisons;
    }

    public void setCombineComparisons(boolean combineComparisons) {
        this.combineComparisons = combineComparisons;
    }

    public boolean isCombineTimepoints() {
        return this.combineTimepoints;
    }

    public void setCombineTimepoints(boolean combineTimepoints) {
        this.combineTimepoints = combineTimepoints;
    }

    public boolean isCombineOutcomes() {
        return this.combineOutcomes;
    }

    public void setCombineOutcomes(boolean combineOutcomes) {
        this.combineOutcomes = combineOutcomes;
    }

    public boolean isCombineSubgroups() {
        return this.combineSubgroups;
    }

    public void setCombineSubgroups(boolean combineSubgroups) {
        this.combineSubgroups = combineSubgroups;
    }

    public Map<Integer, List<String>> getCategoricalModeratorsExcludedValues() {
        return this.categoricalModeratorsExcludedValues;
    }

    public void setCategoricalModeratorsExcludedValues(Map<Integer, List<String>> categoricalModeratorsExcludedValues) {
        this.categoricalModeratorsExcludedValues = categoricalModeratorsExcludedValues;
    }

    public Map<Long, List<String>> getRecodedModeratorsExcludedValues() {
        return this.recodedModeratorsExcludedValues;
    }

    public void setRecodedModeratorsExcludedValues(Map<Long, List<String>> recodedModeratorsExcludedValues) {
        this.recodedModeratorsExcludedValues = recodedModeratorsExcludedValues;
    }

    public List<Integer> getExcludedModerators() {
        return this.excludedModerators;
    }

    public void setExcludedModerators(List<Integer> excludedCategoricalModerators) {
        this.excludedModerators = excludedCategoricalModerators;
    }

    public List<Long> getExcludedRecodedModerators() {
        return this.excludedRecodedModerators;
    }

    public void setExcludedRecodedModerators(List<Long> excludedRecodedModerators) {
        this.excludedRecodedModerators = excludedRecodedModerators;
    }

    public List<Long> getExcludedStudies() {
        return this.excludedStudies;
    }

    public void setExcludedStudies(List<Long> excludedStudies) {
        this.excludedStudies = excludedStudies;
    }

    public List<Integer> getExcludedComparisons() {
        return this.excludedComparisons;
    }

    public void setExcludedComparisons(List<Integer> excludedComparisons) {
        this.excludedComparisons = excludedComparisons;
    }

    public List<Integer> getExcludedSubgroups() {
        return this.excludedSubgroups;
    }

    public void setExcludedSubgroups(List<Integer> excludedSubgroups) {
        this.excludedSubgroups = excludedSubgroups;
    }

    public List<Integer> getExcludedTimepoints() {
        return this.excludedTimepoints;
    }

    public void setExcludedTimepoints(List<Integer> excludedTimepoints) {
        this.excludedTimepoints = excludedTimepoints;
    }

    public List<Integer> getExcludedOutcomes() {
        return this.excludedOutcomes;
    }

    public void setExcludedOutcomes(List<Integer> excludedOutcomes) {
        this.excludedOutcomes = excludedOutcomes;
    }

    public static AnalysisFilter readAnalysisFilter(String analysisFilterString) {
        if (analysisFilterString == null || analysisFilterString.equals("")) {
            return null;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(analysisFilterString.getBytes());
        XMLDecoder d = new XMLDecoder(is);
        Object result = d.readObject();
        d.close();
        return (AnalysisFilter)result;
    }

    public static String writeAnalysisFilter(AnalysisFilter analysisFilter) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEncoder xmlEncoder = new XMLEncoder(baos);
        xmlEncoder.writeObject(analysisFilter);
        xmlEncoder.close();
        return baos.toString();
    }

    public double getCorrelationBetweenOutcomes() {
        return this.correlationBetweenOutcomes;
    }

    public void setCorrelationBetweenOutcomes(double correlationBetweenOutcomes) {
        this.correlationBetweenOutcomes = correlationBetweenOutcomes;
    }

    public double getCorrelationBetweenTimepoints() {
        return this.correlationBetweenTimepoints;
    }

    public void setCorrelationBetweenTimepoints(double correlationBetweenTimepoints) {
        this.correlationBetweenTimepoints = correlationBetweenTimepoints;
    }

    public double getConfidenceInterval() {
        return this.confidenceInterval;
    }

    public void setConfidenceInterval(double confidenceInterval) {
        this.confidenceInterval = confidenceInterval;
    }

    public double getNonEffectLine() {
        if (this.getEffectSizeType().equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oddsRatioLabel")) || this.getEffectSizeType().equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"petoOddsRatioLabel")) || this.getEffectSizeType().equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"riskRatioLabel")) || this.getEffectSizeType().equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"rateRatioLabel")) || this.getEffectSizeType().equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"hazardRatioLabel")) || this.getEffectSizeType().equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.eventRate")) || this.getEffectSizeType().equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.rate"))) {
            return 1.0;
        }
        return 0.0;
    }

    public int getPublicationBiasSearch() {
        return this.publicationBiasSearch;
    }

    public void setPublicationBiasSearch(int publicationBiasSearch) {
        this.publicationBiasSearch = publicationBiasSearch;
    }

    public String getNullValue() {
        return nullValue;
    }
}

