/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.variables;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalysis.actions.models.RemoveComparisonAA;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.flavors.ComparisonFlavor;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ComparisonEvents;
import metaanalysis.core.functionsapi.events.ComparisonUpdatedEvent;
import metaanalysis.core.persistence.Comparison;
import metaanalysis.dataeditor.models.AbstractApplicationNode;
import metaanalysis.dataeditor.models.INodeEditor;
import metaanalysis.guiandnodes.variables.editors.ComparisonEditorPanel;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;

public class ComparisonNode
extends AbstractApplicationNode
implements INodeEditor,
PropertyChangeListener {
    private final Comparison comparison;

    public ComparisonNode(Comparison comparison, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children, Lookups.singleton((Object)comparison));
        this.comparison = comparison;
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/comparison_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/comparison_iconOpen.png");
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() {
        this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveComparisonAA(this.comparison, this.applicationEventWorker));
    }

    public Transferable clipboardCut() throws IOException {
        Transferable deflt = super.clipboardCut();
        ExTransferable added = ExTransferable.create((Transferable)deflt);
        added.put(new ExTransferable.Single(ComparisonFlavor.COMPARISON_FLAVOR){

            protected Comparison getData() {
                return (Comparison)ComparisonNode.this.getLookup().lookup(Comparison.class);
            }
        });
        return added;
    }

    public Transferable clipboardCopy() throws IOException {
        Transferable deflt = super.clipboardCopy();
        ExTransferable added = ExTransferable.create((Transferable)deflt);
        added.put(new ExTransferable.Single(ComparisonFlavor.COMPARISON_FLAVOR){

            protected Comparison getData() {
                return (Comparison)ComparisonNode.this.getLookup().lookup(Comparison.class);
            }
        });
        return added;
    }

    public String getDisplayName() {
        return ((Comparison)this.getLookup().lookup(Comparison.class)).getName();
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new RemoveComparisonAction()};
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent") && pce.getNewValue() instanceof ComparisonEvents && ((ComparisonEvents)pce.getNewValue()).getComparison().getId() == this.comparison.getId() && pce.getNewValue() instanceof ComparisonUpdatedEvent) {
            ComparisonUpdatedEvent tmp = (ComparisonUpdatedEvent)pce.getNewValue();
            this.comparison.copyFrom(tmp.getComparison());
            this.setName(this.comparison.getName());
            this.setDisplayName(this.comparison.getName());
        }
    }

    public ComparisonEditorPanel getNodeEditor() {
        return new ComparisonEditorPanel(this.comparison.getId(), this.applicationEventWorker, new GuiChecker(this.applicationEventWorker.getEditorPanelsUndoRedoManager(), TuliTuliTools.isAutoSelectContentFieldEnabled()));
    }

    private class RemoveComparisonAction
    extends AbstractAction
    implements Presenter.Popup {
        public RemoveComparisonAction() {
            this.putValue("Name", NbBundle.getMessage(RemoveComparisonAction.class, (String)"ComparisonNode.RemoveAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ComparisonNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveComparisonAA(ComparisonNode.this.comparison, ComparisonNode.this.applicationEventWorker));
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/delete_icon.png")));
            return x;
        }
    }
}

