/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.variables;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalysis.actions.models.DefineComparisonAA;
import metaanalysis.analysis.variables.ComparisonModelVariableStatisticBuilder;
import metaanalysis.analysis.variables.IVariablesStatisticReport;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ComparisonCreatedEvent;
import metaanalysis.core.persistence.Topic;
import metaanalysis.dataeditor.models.AbstractContainerNode;
import metaanalysis.dataeditor.models.INodeEditor;
import metaanalysis.events.models.ExpandNode;
import metaanalysis.events.models.IApplicationEvent;
import metaanalysis.guiandnodes.variables.editors.VariablesEditorPanel;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class ComparisonsContainerNode
extends AbstractContainerNode
implements INodeEditor,
PropertyChangeListener {
    private final ComparisonModelVariableStatisticBuilder modelVariableStatisticBuilder;
    private Topic topic;

    public ComparisonsContainerNode(Topic topic, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children);
        this.modelVariableStatisticBuilder = new ComparisonModelVariableStatisticBuilder(topic.getId(), applicationEventWorker);
        this.topic = topic;
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/comparison_folder_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/comparison_folder_iconOpen.png");
    }

    public Action[] getActions(boolean popup) {
        ArrayList<AddAction> actions = new ArrayList<AddAction>();
        actions.add(new AddAction());
        return actions.toArray(new Action[actions.size()]);
    }

    public VariablesEditorPanel getNodeEditor() {
        return new VariablesEditorPanel((IVariablesStatisticReport)this.modelVariableStatisticBuilder, this.applicationEventWorker, new GuiChecker(this.applicationEventWorker.getEditorPanelsUndoRedoManager(), TuliTuliTools.isAutoSelectContentFieldEnabled()));
    }

    public String getHtmlDisplayName() {
        return NbBundle.getMessage(ComparisonsContainerNode.class, (String)"ComparisonsContainerNode.displayName");
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent") && pce.getNewValue() instanceof ComparisonCreatedEvent) {
            this.applicationEventWorker.setApplicationEvent((IApplicationEvent)new ExpandNode((Node)this));
        }
    }

    private class AddAction
    extends AbstractAction
    implements Presenter.Popup {
        public AddAction() {
            this.putValue("Name", NbBundle.getMessage(AddAction.class, (String)"AddComparisonAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String nome = JOptionPane.showInputDialog(null, NbBundle.getMessage(AddAction.class, (String)"AddComparisonAction.newComparisonName"), NbBundle.getMessage(AddAction.class, (String)"AddComparisonAction.insertNewComparisonBarTitle"), 1);
            if (nome != null) {
                ComparisonsContainerNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineComparisonAA(nome, ComparisonsContainerNode.this.topic, ComparisonsContainerNode.this.applicationEventWorker));
            }
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/create_icon.png")));
            return x;
        }
    }
}

