/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.variables;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalysis.actions.models.RemoveOutcomeAA;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.flavors.OutcomeFlavor;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.OutcomeEvents;
import metaanalysis.core.functionsapi.events.OutcomeUpdatedEvent;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.dataeditor.models.AbstractApplicationNode;
import metaanalysis.dataeditor.models.INodeEditor;
import metaanalysis.guiandnodes.variables.editors.OutcomeEditorPanel;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;

public class OutcomeNode
extends AbstractApplicationNode
implements INodeEditor,
PropertyChangeListener {
    private final Outcome outcome;

    public OutcomeNode(Outcome outcome, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children, Lookups.singleton((Object)outcome));
        this.outcome = outcome;
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/outcome_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/outcome_iconOpen.png");
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() {
        this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveOutcomeAA(this.outcome, this.applicationEventWorker));
    }

    public Transferable clipboardCut() throws IOException {
        Transferable deflt = super.clipboardCut();
        ExTransferable added = ExTransferable.create((Transferable)deflt);
        added.put(new ExTransferable.Single(OutcomeFlavor.OUTCOME_FLAVOR){

            protected Outcome getData() {
                return (Outcome)OutcomeNode.this.getLookup().lookup(Outcome.class);
            }
        });
        return added;
    }

    public Transferable clipboardCopy() throws IOException {
        Transferable deflt = super.clipboardCopy();
        ExTransferable added = ExTransferable.create((Transferable)deflt);
        added.put(new ExTransferable.Single(OutcomeFlavor.OUTCOME_FLAVOR){

            protected Outcome getData() {
                return (Outcome)OutcomeNode.this.getLookup().lookup(Outcome.class);
            }
        });
        return added;
    }

    public String getDisplayName() {
        return ((Outcome)this.getLookup().lookup(Outcome.class)).getName();
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new RemoveOutcomeAction()};
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent") && pce.getNewValue() instanceof OutcomeEvents && ((OutcomeEvents)pce.getNewValue()).getOutcome().getId() == this.outcome.getId() && pce.getNewValue() instanceof OutcomeUpdatedEvent) {
            OutcomeUpdatedEvent tmp = (OutcomeUpdatedEvent)pce.getNewValue();
            this.outcome.copyFrom(tmp.getOutcome());
            this.setName(this.outcome.getName());
            this.setDisplayName(this.outcome.getName());
        }
    }

    public OutcomeEditorPanel getNodeEditor() {
        return new OutcomeEditorPanel(this.outcome.getId(), this.applicationEventWorker, new GuiChecker(this.applicationEventWorker.getEditorPanelsUndoRedoManager(), TuliTuliTools.isAutoSelectContentFieldEnabled()));
    }

    private class RemoveOutcomeAction
    extends AbstractAction
    implements Presenter.Popup {
        public RemoveOutcomeAction() {
            this.putValue("Name", NbBundle.getMessage(RemoveOutcomeAction.class, (String)"OutcomeNode.RemoveAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OutcomeNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveOutcomeAA(OutcomeNode.this.outcome, OutcomeNode.this.applicationEventWorker));
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/delete_icon.png")));
            return x;
        }
    }
}

