/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.variables;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalysis.actions.models.DefineOutcomeAA;
import metaanalysis.analysis.variables.IVariablesStatisticReport;
import metaanalysis.analysis.variables.OutcomeModelVariableStatisticBuilder;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.OutcomeCreatedEvent;
import metaanalysis.core.persistence.Topic;
import metaanalysis.dataeditor.models.AbstractContainerNode;
import metaanalysis.dataeditor.models.INodeEditor;
import metaanalysis.events.models.ExpandNode;
import metaanalysis.events.models.IApplicationEvent;
import metaanalysis.guiandnodes.variables.editors.OutcomesContainerEditorPanel;
import metaanalysis.guiandnodes.variables.editors.VariablesEditorPanel;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class OutcomesContainerNode
extends AbstractContainerNode
implements INodeEditor,
PropertyChangeListener {
    private Topic topic;
    private final OutcomeModelVariableStatisticBuilder outcomeModelVariableStatisticBuilder;

    public OutcomesContainerNode(Topic topic, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children);
        this.outcomeModelVariableStatisticBuilder = new OutcomeModelVariableStatisticBuilder(topic.getId(), applicationEventWorker);
        this.topic = topic;
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/outcome_folder_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/outcome_folder_iconOpen.png");
    }

    public Action[] getActions(boolean popup) {
        ArrayList<AddOutcomeAction> actions = new ArrayList<AddOutcomeAction>();
        actions.add(new AddOutcomeAction());
        return actions.toArray(new Action[actions.size()]);
    }

    public VariablesEditorPanel getNodeEditor() {
        return new OutcomesContainerEditorPanel((IVariablesStatisticReport)this.outcomeModelVariableStatisticBuilder, this.applicationEventWorker, new GuiChecker(this.applicationEventWorker.getEditorPanelsUndoRedoManager(), TuliTuliTools.isAutoSelectContentFieldEnabled()));
    }

    public String getHtmlDisplayName() {
        return NbBundle.getMessage(OutcomesContainerNode.class, (String)"OutcomesContainerNode.displayName");
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent") && pce.getNewValue() instanceof OutcomeCreatedEvent) {
            this.applicationEventWorker.setApplicationEvent((IApplicationEvent)new ExpandNode((Node)this));
        }
    }

    private class AddOutcomeAction
    extends AbstractAction
    implements Presenter.Popup {
        public AddOutcomeAction() {
            this.putValue("Name", NbBundle.getMessage(AddOutcomeAction.class, (String)"AddOutcomeAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String nome = JOptionPane.showInputDialog(null, NbBundle.getMessage(AddOutcomeAction.class, (String)"AddOutcomeAction.newOutcomeName"), NbBundle.getMessage(AddOutcomeAction.class, (String)"AddOutcomeAction.insertNewOutcomeBarTitle"), 1);
            if (nome != null) {
                OutcomesContainerNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineOutcomeAA(nome, OutcomesContainerNode.this.topic, OutcomesContainerNode.this.applicationEventWorker));
            }
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/create_icon.png")));
            return x;
        }
    }
}

