/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.variables;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalysis.actions.models.RemoveSubgroupAA;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.flavors.SubgroupFlavor;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.SubgroupEvents;
import metaanalysis.core.functionsapi.events.SubgroupUpdatedEvent;
import metaanalysis.core.persistence.Subgroup;
import metaanalysis.dataeditor.models.AbstractApplicationNode;
import metaanalysis.dataeditor.models.INodeEditor;
import metaanalysis.guiandnodes.variables.editors.SubgroupEditorPanel;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;

public class SubgroupNode
extends AbstractApplicationNode
implements INodeEditor,
PropertyChangeListener {
    private final Subgroup subgroup;

    public SubgroupNode(Subgroup subgroup, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children, Lookups.singleton((Object)subgroup));
        this.subgroup = subgroup;
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/subgroup_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/subgroup_iconOpen.png");
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() {
        this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveSubgroupAA(this.subgroup, this.applicationEventWorker));
    }

    public Transferable clipboardCut() throws IOException {
        Transferable deflt = super.clipboardCut();
        ExTransferable added = ExTransferable.create((Transferable)deflt);
        added.put(new ExTransferable.Single(SubgroupFlavor.SUBGROUP_FLAVOR){

            protected Subgroup getData() {
                return (Subgroup)SubgroupNode.this.getLookup().lookup(Subgroup.class);
            }
        });
        return added;
    }

    public Transferable clipboardCopy() throws IOException {
        Transferable deflt = super.clipboardCopy();
        ExTransferable added = ExTransferable.create((Transferable)deflt);
        added.put(new ExTransferable.Single(SubgroupFlavor.SUBGROUP_FLAVOR){

            protected Subgroup getData() {
                return (Subgroup)SubgroupNode.this.getLookup().lookup(Subgroup.class);
            }
        });
        return added;
    }

    public String getDisplayName() {
        return ((Subgroup)this.getLookup().lookup(Subgroup.class)).getName();
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new RemoveSubgroupAction()};
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent") && pce.getNewValue() instanceof SubgroupEvents && ((SubgroupEvents)pce.getNewValue()).getSubgroup().getId() == this.subgroup.getId() && pce.getNewValue() instanceof SubgroupUpdatedEvent) {
            SubgroupUpdatedEvent tmp = (SubgroupUpdatedEvent)pce.getNewValue();
            this.subgroup.copyFrom(tmp.getSubgroup());
            this.setName(this.subgroup.getName());
            this.setDisplayName(this.subgroup.getName());
        }
    }

    public SubgroupEditorPanel getNodeEditor() {
        return new SubgroupEditorPanel(this.subgroup.getId(), this.applicationEventWorker, new GuiChecker(this.applicationEventWorker.getEditorPanelsUndoRedoManager(), TuliTuliTools.isAutoSelectContentFieldEnabled()));
    }

    private class RemoveSubgroupAction
    extends AbstractAction
    implements Presenter.Popup {
        public RemoveSubgroupAction() {
            this.putValue("Name", NbBundle.getMessage(RemoveSubgroupAction.class, (String)"SubgroupNode.RemoveAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SubgroupNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveSubgroupAA(SubgroupNode.this.subgroup, SubgroupNode.this.applicationEventWorker));
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/delete_icon.png")));
            return x;
        }
    }
}

