/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.variables;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalysis.actions.models.DefineSubgroupAA;
import metaanalysis.analysis.variables.IVariablesStatisticReport;
import metaanalysis.analysis.variables.SubgroupModelVariableStatisticBuilder;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.flavors.SubgroupFlavor;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.SubgroupCreatedEvent;
import metaanalysis.core.persistence.Topic;
import metaanalysis.dataeditor.models.AbstractContainerNode;
import metaanalysis.dataeditor.models.INodeEditor;
import metaanalysis.events.models.ExpandNode;
import metaanalysis.events.models.IApplicationEvent;
import metaanalysis.guiandnodes.variables.editors.VariablesEditorPanel;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.datatransfer.PasteType;

public class SubgroupsContainerNode
extends AbstractContainerNode
implements INodeEditor,
PropertyChangeListener {
    private final SubgroupModelVariableStatisticBuilder modelVariableStatisticBuilder;
    private Topic topic;

    public SubgroupsContainerNode(Topic topic, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children);
        this.modelVariableStatisticBuilder = new SubgroupModelVariableStatisticBuilder(topic.getId(), applicationEventWorker);
        this.topic = topic;
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/subgroup_folder_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/subgroup_folder_iconOpen.png");
    }

    public Action[] getActions(boolean popup) {
        ArrayList<AddSubgroupAction> actions = new ArrayList<AddSubgroupAction>();
        actions.add(new AddSubgroupAction(this.applicationEventWorker));
        return actions.toArray(new Action[actions.size()]);
    }

    public PasteType getDropType(Transferable t, int arg1, int arg2) {
        if (t.isDataFlavorSupported(SubgroupFlavor.SUBGROUP_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    return null;
                }
            };
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        long aaaa = new Date().getTime();
        super.createPasteTypes(t, s);
        PasteType p = this.getDropType(t, 0, 0);
        if (p != null) {
            s.add(p);
        }
    }

    public VariablesEditorPanel getNodeEditor() {
        return new VariablesEditorPanel((IVariablesStatisticReport)this.modelVariableStatisticBuilder, this.applicationEventWorker, new GuiChecker(this.applicationEventWorker.getEditorPanelsUndoRedoManager(), TuliTuliTools.isAutoSelectContentFieldEnabled()));
    }

    public String getHtmlDisplayName() {
        return NbBundle.getMessage(SubgroupsContainerNode.class, (String)"SubgroupsContainerNode.displayName");
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent") && pce.getNewValue() instanceof SubgroupCreatedEvent) {
            this.applicationEventWorker.setApplicationEvent((IApplicationEvent)new ExpandNode((Node)this));
        }
    }

    private class AddSubgroupAction
    extends AbstractAction
    implements Presenter.Popup {
        public AddSubgroupAction(IApplicationManager applicationEventWorker) {
            this.putValue("Name", NbBundle.getMessage(AddSubgroupAction.class, (String)"AddSubgroupAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String nome = JOptionPane.showInputDialog(null, NbBundle.getMessage(AddSubgroupAction.class, (String)"AddSubgroupAction.newSubgroupName"), NbBundle.getMessage(AddSubgroupAction.class, (String)"AddSubgroupAction.insertNewSubgroupBarTitle"), 1);
            if (nome != null) {
                SubgroupsContainerNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineSubgroupAA(nome, SubgroupsContainerNode.this.topic, SubgroupsContainerNode.this.applicationEventWorker));
            }
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/create_icon.png")));
            return x;
        }
    }
}

