/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.variables;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalysis.analysis.variables.IVariablesStatisticReport;
import metaanalysis.analysis.variables.TimepointModelVariableStatisticBuilder;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.flavors.Timepoint;
import metaanalysis.core.flavors.TimepointFlavor;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Topic;
import metaanalysis.dataeditor.models.AbstractApplicationNode;
import metaanalysis.dataeditor.models.INodeEditor;
import metaanalysis.guiandnodes.variables.editors.VariablesEditorPanel;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;

public class TimepointNode
extends AbstractApplicationNode
implements INodeEditor {
    private final Timepoint timepoint;
    private final TimepointModelVariableStatisticBuilder modelVariableStatisticBuilder;
    private Topic topic;

    public TimepointNode(Topic topic, Timepoint timepoint, IApplicationManager applicationEventWorker) {
        super(applicationEventWorker, Children.LEAF, Lookups.singleton((Object)timepoint));
        this.timepoint = timepoint;
        this.setDisplayName("Waves");
        this.modelVariableStatisticBuilder = new TimepointModelVariableStatisticBuilder(topic.getId(), applicationEventWorker);
    }

    public Topic getTopic() {
        return this.topic;
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/timepoint_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/timepoint_iconOpen.png");
    }

    public boolean canCopy() {
        return true;
    }

    public Transferable clipboardCut() throws IOException {
        Transferable deflt = super.clipboardCut();
        ExTransferable added = ExTransferable.create((Transferable)deflt);
        added.put(new ExTransferable.Single(TimepointFlavor.TIMEPOINT_FLAVOR){

            protected Timepoint getData() {
                return (Timepoint)TimepointNode.this.getLookup().lookup(Timepoint.class);
            }
        });
        return added;
    }

    public Transferable clipboardCopy() throws IOException {
        Transferable deflt = super.clipboardCopy();
        ExTransferable added = ExTransferable.create((Transferable)deflt);
        added.put(new ExTransferable.Single(TimepointFlavor.TIMEPOINT_FLAVOR){

            protected Timepoint getData() {
                return (Timepoint)TimepointNode.this.getLookup().lookup(Timepoint.class);
            }
        });
        return added;
    }

    public VariablesEditorPanel getNodeEditor() {
        return new VariablesEditorPanel((IVariablesStatisticReport)this.modelVariableStatisticBuilder, this.applicationEventWorker, new GuiChecker(this.applicationEventWorker.getEditorPanelsUndoRedoManager(), TuliTuliTools.isAutoSelectContentFieldEnabled()));
    }
}

