/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.variables.childfactory;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import metaanalysis.core.entitycomparators.ComparisonNameComparator;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ComparisonCreatedEvent;
import metaanalysis.core.functionsapi.events.ComparisonDeletedEvent;
import metaanalysis.core.functionsapi.events.ComparisonEvents;
import metaanalysis.core.persistence.Comparison;
import metaanalysis.core.persistence.Topic;
import metaanalysis.guiandnodes.variables.ComparisonNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class ComparisonsContainerChildFactory
extends ChildFactory.Detachable<Comparison>
implements PropertyChangeListener {
    private final IApplicationManager applicationEventWorker;
    private final Topic topic;

    public ComparisonsContainerChildFactory(IApplicationManager applicationEventRegister, Topic topic) {
        this.topic = topic;
        this.applicationEventWorker = applicationEventRegister;
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
    }

    protected boolean createKeys(List<Comparison> list) {
        list.addAll(this.applicationEventWorker.getIDataFunction().getAllComparisonsOfTopic(this.topic));
        Collections.sort(list, new ComparisonNameComparator());
        return true;
    }

    protected Node createNodeForKey(Comparison key) {
        return new ComparisonNode(key, this.applicationEventWorker, Children.LEAF);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent") && pce.getNewValue() instanceof ComparisonEvents && (pce.getNewValue() instanceof ComparisonCreatedEvent || pce.getNewValue() instanceof ComparisonDeletedEvent)) {
            this.refresh(true);
        }
    }
}

