/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.variables.childfactory;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import metaanalysis.core.entitycomparators.OutcomeNameComparator;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.OutcomeCreatedEvent;
import metaanalysis.core.functionsapi.events.OutcomeDeletedEvent;
import metaanalysis.core.functionsapi.events.OutcomeEvents;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Topic;
import metaanalysis.guiandnodes.variables.OutcomeNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class OutcomesContainerChildFactory
extends ChildFactory.Detachable<Outcome>
implements PropertyChangeListener {
    private final IApplicationManager applicationEventWorker;
    private final Topic topic;

    public OutcomesContainerChildFactory(IApplicationManager applicationEventRegister, Topic topic) {
        this.topic = topic;
        this.applicationEventWorker = applicationEventRegister;
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
    }

    protected boolean createKeys(List<Outcome> list) {
        list.addAll(this.applicationEventWorker.getIDataFunction().getAllOutcomesOfTopic(this.topic));
        Collections.sort(list, new OutcomeNameComparator());
        return true;
    }

    protected Node createNodeForKey(Outcome key) {
        return new OutcomeNode(key, this.applicationEventWorker, Children.LEAF);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent") && pce.getNewValue() instanceof OutcomeEvents && (pce.getNewValue() instanceof OutcomeCreatedEvent || pce.getNewValue() instanceof OutcomeDeletedEvent)) {
            this.refresh(true);
        }
    }
}

