/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.variables.childfactory;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import metaanalysis.core.entitycomparators.SubgroupNameComparator;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.SubgroupCreatedEvent;
import metaanalysis.core.functionsapi.events.SubgroupDeletedEvent;
import metaanalysis.core.functionsapi.events.SubgroupEvents;
import metaanalysis.core.persistence.Subgroup;
import metaanalysis.core.persistence.Topic;
import metaanalysis.guiandnodes.variables.SubgroupNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class SubgroupsContainerChildFactory
extends ChildFactory.Detachable<Subgroup>
implements PropertyChangeListener {
    private final IApplicationManager applicationEventWorker;
    private final Topic topic;

    public SubgroupsContainerChildFactory(IApplicationManager applicationEventRegister, Topic topic) {
        this.topic = topic;
        this.applicationEventWorker = applicationEventRegister;
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
    }

    protected boolean createKeys(List<Subgroup> list) {
        list.addAll(this.applicationEventWorker.getIDataFunction().getAllSubgroupsOfTopic(this.topic));
        Collections.sort(list, new SubgroupNameComparator());
        return true;
    }

    protected Node createNodeForKey(Subgroup key) {
        return new SubgroupNode(key, this.applicationEventWorker, Children.LEAF);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent") && pce.getNewValue() instanceof SubgroupEvents && (pce.getNewValue() instanceof SubgroupCreatedEvent || pce.getNewValue() instanceof SubgroupDeletedEvent)) {
            this.refresh(true);
        }
    }
}

