/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.variables.editors;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import metaanalsysis.guiutil.guicheckers.AbstractRole;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalsysis.guiutil.guicheckers.StringNotNullRole;
import metaanalysis.actions.models.UpdateComparisonAA;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ComparisonEvents;
import metaanalysis.core.persistence.Comparison;
import metaanalysis.dataeditor.models.AbstractEditorPanel;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ComparisonEditorPanel
extends AbstractEditorPanel {
    private Comparison comparison;
    private int comparisonId;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel nameLabel;
    private JTextField nameValue;
    private JTextArea noteArea;
    private JButton saveButton;

    public ComparisonEditorPanel(int comparisonId, IApplicationManager applicationEventWorker, GuiChecker guiChecker) {
        super(applicationEventWorker, guiChecker);
        this.comparisonId = comparisonId;
        this.initComponents();
        this.reloadAll();
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameValue = new JTextField();
        this.saveButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.noteArea = new JTextArea();
        this.nameLabel.setText(NbBundle.getMessage(ComparisonEditorPanel.class, (String)"ComparisonEditorPanel.nameLabel.text"));
        this.nameValue.setText(NbBundle.getMessage(ComparisonEditorPanel.class, (String)"ComparisonEditorPanel.nameValue.text"));
        this.saveButton.setText(NbBundle.getMessage(ComparisonEditorPanel.class, (String)"ComparisonEditorPanel.saveButton.text"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComparisonEditorPanel.this.saveButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText(NbBundle.getMessage(ComparisonEditorPanel.class, (String)"ComparisonEditorPanel.jLabel1.text"));
        this.noteArea.setColumns(20);
        this.noteArea.setRows(5);
        this.jScrollPane1.setViewportView(this.noteArea);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.saveButton).addGroup(layout.createSequentialGroup().addComponent(this.nameLabel, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameValue, -2, 223, -2))).addComponent(this.jScrollPane1)).addComponent(this.jLabel1)).addContainerGap(38, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(46, 46, 46).addComponent(this.saveButton)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameValue, -2, -1, -2))).addGap(19, 19, 19).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 133, -2).addGap(47, 47, 47)));
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.comparison.setName(this.nameValue.getText());
        this.comparison.setNote(this.noteArea.getText());
        this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new UpdateComparisonAA(this.comparison, this.applicationEventWorker));
        try {
            Thread.sleep(TuliTuliTools.waitngTime);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public final void reloadAll() {
        this.guiChecker.svuota();
        this.comparison = this.applicationEventWorker.getIDataFunction().getComparison(this.comparisonId);
        if (this.comparison == null) {
            this.scompari();
        } else {
            this.appari();
            this.guiChecker.addRole((AbstractRole)new StringNotNullRole(this.nameValue, this.comparison.getName()));
            this.guiChecker.checkWhitoutFix();
            this.noteArea.setText(this.comparison.getNote());
        }
    }

    public boolean readApplicationEvent(IApplicationEvent event) {
        if (event instanceof ComparisonEvents && ((ComparisonEvents)event).getComparison().getId() == this.comparisonId) {
            this.reloadAll();
            return true;
        }
        return false;
    }

    public String getBarTitle() {
        return NbBundle.getMessage(ComparisonEditorPanel.class, (String)"ComparisonEditor.barTitle");
    }
}

