/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.variables.editors;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import metaanalsysis.guiutil.guicheckers.AbstractRole;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalsysis.guiutil.guicheckers.StringNotNullRole;
import metaanalysis.actions.models.UpdateOutcomeAA;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.OutcomeEvents;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.dataeditor.models.AbstractEditorPanel;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class OutcomeEditorPanel
extends AbstractEditorPanel {
    private Outcome outcome;
    private boolean saveButtonActive = false;
    private final int outcomeId;
    private JTextField eventField;
    private JTextField groupAField;
    private JTextField groupBField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JScrollPane jScrollPane1;
    private JLabel nameLabel;
    private JTextField nameValueField;
    private JTextField nonEventField;
    private JTextArea noteArea;
    private JButton saveButton;

    public OutcomeEditorPanel(int outcomeId, IApplicationManager applicationEventWorker, GuiChecker guiChecker) {
        super(applicationEventWorker, guiChecker);
        this.initComponents();
        this.outcomeId = outcomeId;
        this.reloadAll();
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameValueField = new JTextField();
        this.saveButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.groupAField = new JTextField();
        this.jLabel3 = new JLabel();
        this.groupBField = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.eventField = new JTextField();
        this.jLabel6 = new JLabel();
        this.nonEventField = new JTextField();
        this.jLabel7 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.noteArea = new JTextArea();
        this.nameLabel.setText(NbBundle.getMessage(OutcomeEditorPanel.class, (String)"OutcomeEditorPanel.nameLabel.text"));
        this.nameValueField.setText(NbBundle.getMessage(OutcomeEditorPanel.class, (String)"OutcomeEditorPanel.nameValueField.text"));
        this.saveButton.setText(NbBundle.getMessage(OutcomeEditorPanel.class, (String)"OutcomeEditorPanel.saveButton.text"));
        this.saveButton.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                OutcomeEditorPanel.this.saveButtonMouseMoved(evt);
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutcomeEditorPanel.this.saveButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText(NbBundle.getMessage(OutcomeEditorPanel.class, (String)"OutcomeEditorPanel.jLabel1.text"));
        this.jLabel2.setText(NbBundle.getMessage(OutcomeEditorPanel.class, (String)"OutcomeEditorPanel.jLabel2.text"));
        this.groupAField.setHorizontalAlignment(2);
        this.groupAField.setText(NbBundle.getMessage(OutcomeEditorPanel.class, (String)"OutcomeEditorPanel.groupAField.text"));
        this.groupAField.setMaximumSize(new Dimension(117, 28));
        this.groupAField.setMinimumSize(new Dimension(117, 28));
        this.groupAField.setPreferredSize(new Dimension(117, 28));
        this.groupAField.setSize(new Dimension(117, 28));
        this.jLabel3.setText(NbBundle.getMessage(OutcomeEditorPanel.class, (String)"OutcomeEditorPanel.jLabel3.text"));
        this.groupBField.setHorizontalAlignment(2);
        this.groupBField.setText(NbBundle.getMessage(OutcomeEditorPanel.class, (String)"OutcomeEditorPanel.groupBField.text"));
        this.groupBField.setMaximumSize(new Dimension(117, 28));
        this.groupBField.setMinimumSize(new Dimension(117, 28));
        this.groupBField.setPreferredSize(new Dimension(117, 28));
        this.groupBField.setSize(new Dimension(117, 28));
        this.jLabel4.setText(NbBundle.getMessage(OutcomeEditorPanel.class, (String)"OutcomeEditorPanel.jLabel4.text"));
        this.jLabel5.setText(NbBundle.getMessage(OutcomeEditorPanel.class, (String)"OutcomeEditorPanel.jLabel5.text"));
        this.eventField.setHorizontalAlignment(2);
        this.eventField.setText(NbBundle.getMessage(OutcomeEditorPanel.class, (String)"OutcomeEditorPanel.eventField.text"));
        this.eventField.setMaximumSize(new Dimension(117, 28));
        this.eventField.setMinimumSize(new Dimension(117, 28));
        this.eventField.setPreferredSize(new Dimension(117, 28));
        this.eventField.setSize(new Dimension(117, 28));
        this.jLabel6.setText(NbBundle.getMessage(OutcomeEditorPanel.class, (String)"OutcomeEditorPanel.jLabel6.text"));
        this.nonEventField.setHorizontalAlignment(2);
        this.nonEventField.setText(NbBundle.getMessage(OutcomeEditorPanel.class, (String)"OutcomeEditorPanel.nonEventField.text"));
        this.nonEventField.setMaximumSize(new Dimension(117, 28));
        this.nonEventField.setMinimumSize(new Dimension(117, 28));
        this.nonEventField.setPreferredSize(new Dimension(117, 28));
        this.nonEventField.setSize(new Dimension(117, 28));
        this.jLabel7.setText(NbBundle.getMessage(OutcomeEditorPanel.class, (String)"OutcomeEditorPanel.jLabel7.text"));
        this.noteArea.setColumns(20);
        this.noteArea.setRows(5);
        this.jScrollPane1.setViewportView(this.noteArea);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.nameLabel, -2, 69, -2).addGap(18, 18, 18).addComponent(this.nameValueField, -2, 139, -2)).addComponent(this.jLabel1, -2, 122, -2).addComponent(this.jLabel4, -2, 122, -2).addComponent(this.jLabel7, -2, 356, -2).addComponent(this.jScrollPane1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.saveButton).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -2, 97, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.eventField, -2, 108, -2).addComponent(this.nonEventField, -2, 109, -2))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, 98, Short.MAX_VALUE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.groupAField, -2, 108, -2).addComponent(this.groupBField, -2, 108, -2)))).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameValueField, -2, -1, -2)).addGap(40, 40, 40).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.groupAField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.groupBField, -2, -1, -2)).addGap(30, 30, 30).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, GroupLayout.Alignment.TRAILING).addComponent(this.eventField, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.nonEventField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.saveButton).addGap(18, 18, 18).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 122, -2).addContainerGap(41, Short.MAX_VALUE)));
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.outcome.setName(this.nameValueField.getText());
        this.outcome.setGroupa(this.groupAField.getText());
        this.outcome.setGroupb(this.groupBField.getText());
        this.outcome.setEvent(this.eventField.getText());
        this.outcome.setNonevent(this.nonEventField.getText());
        this.outcome.setNote(this.noteArea.getText());
        this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new UpdateOutcomeAA(this.outcome, this.applicationEventWorker));
        try {
            Thread.sleep(TuliTuliTools.waitngTime);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void saveButtonMouseMoved(MouseEvent evt) {
        this.guiChecker.checkAndFix();
    }

    public final void reloadAll() {
        this.guiChecker.svuota();
        this.outcome = this.applicationEventWorker.getIDataFunction().getOutcome(this.outcomeId);
        if (this.outcome == null) {
            this.scompari();
        } else {
            this.appari();
            this.guiChecker.getEligibleObjects().add(this.saveButton);
            this.guiChecker.addRole((AbstractRole)new StringNotNullRole(this.groupAField, this.outcome.getGroupa()));
            this.guiChecker.addRole((AbstractRole)new StringNotNullRole(this.groupBField, this.outcome.getGroupb()));
            this.guiChecker.addRole((AbstractRole)new StringNotNullRole(this.eventField, this.outcome.getEvent()));
            this.guiChecker.addRole((AbstractRole)new StringNotNullRole(this.nonEventField, this.outcome.getNonevent()));
            this.guiChecker.addRole((AbstractRole)new StringNotNullRole(this.nameValueField, this.outcome.getName()));
            this.guiChecker.checkWhitoutFix();
            this.noteArea.setText(this.outcome.getNote());
        }
    }

    public boolean readApplicationEvent(IApplicationEvent event) {
        if (event instanceof OutcomeEvents && ((OutcomeEvents)event).getOutcome().getId() == this.outcomeId) {
            this.reloadAll();
            return true;
        }
        return false;
    }

    public String getBarTitle() {
        return NbBundle.getMessage(OutcomeEditorPanel.class, (String)"OutcomeEditor.barTitle");
    }
}

