/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.variables.editors;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import metaanalsysis.guiutil.guicheckers.AbstractRole;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalsysis.guiutil.guicheckers.StringNotNullRole;
import metaanalysis.actions.models.UpdateSubgroupAA;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.SubgroupEvents;
import metaanalysis.core.persistence.Subgroup;
import metaanalysis.dataeditor.models.AbstractEditorPanel;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SubgroupEditorPanel
extends AbstractEditorPanel {
    private Subgroup subgroup;
    private boolean saveButtonActive = false;
    private final int subgroupId;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel nameLabel;
    private JTextField nameValue;
    private JTextArea noteArea;
    private JButton saveButton;

    public SubgroupEditorPanel(int subgroupId, IApplicationManager applicationEventWorker, GuiChecker guiChecker) {
        super(applicationEventWorker, guiChecker);
        this.initComponents();
        this.subgroupId = subgroupId;
        this.reloadAll();
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameValue = new JTextField();
        this.saveButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.noteArea = new JTextArea();
        this.jLabel1 = new JLabel();
        this.nameLabel.setText(NbBundle.getMessage(SubgroupEditorPanel.class, (String)"SubgroupEditorPanel.nameLabel.text"));
        this.nameValue.setText(NbBundle.getMessage(SubgroupEditorPanel.class, (String)"SubgroupEditorPanel.nameValue.text"));
        this.nameValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SubgroupEditorPanel.this.nameValueKeyReleased(evt);
            }
        });
        this.saveButton.setText(NbBundle.getMessage(SubgroupEditorPanel.class, (String)"SubgroupEditorPanel.saveButton.text"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubgroupEditorPanel.this.saveButtonActionPerformed(evt);
            }
        });
        this.noteArea.setColumns(20);
        this.noteArea.setRows(5);
        this.jScrollPane1.setViewportView(this.noteArea);
        this.jLabel1.setText(NbBundle.getMessage(SubgroupEditorPanel.class, (String)"SubgroupEditorPanel.jLabel1.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.saveButton).addGroup(layout.createSequentialGroup().addComponent(this.nameLabel, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameValue, -2, 223, -2))).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING)).addContainerGap(38, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameValue, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.saveButton).addGap(19, 19, 19).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 133, -2).addContainerGap(60, Short.MAX_VALUE)));
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.subgroup.setName(this.nameValue.getText());
        this.subgroup.setNote(this.noteArea.getText());
        this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new UpdateSubgroupAA(this.subgroup, this.applicationEventWorker));
        try {
            Thread.sleep(TuliTuliTools.waitngTime);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void nameValueKeyReleased(KeyEvent evt) {
        this.guiChecker.fieldChange(this.nameValue);
        this.validate();
    }

    public final void reloadAll() {
        this.guiChecker.svuota();
        this.subgroup = this.applicationEventWorker.getIDataFunction().getSubgroup(this.subgroupId);
        if (this.subgroup == null) {
            this.scompari();
        } else {
            this.appari();
            this.guiChecker.addRole((AbstractRole)new StringNotNullRole(this.nameValue, this.subgroup.getName()));
            this.guiChecker.checkWhitoutFix();
            this.noteArea.setText(this.subgroup.getNote());
        }
    }

    public boolean readApplicationEvent(IApplicationEvent event) {
        if (event instanceof SubgroupEvents && ((SubgroupEvents)event).getSubgroup().getId() == this.subgroupId) {
            this.reloadAll();
            return true;
        }
        return false;
    }

    public String getBarTitle() {
        return NbBundle.getMessage(SubgroupEditorPanel.class, (String)"SubgroupEditor.barTitle");
    }
}

