/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.variables.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalysis.analysis.variables.IVariablesStatisticReport;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.DataBaseEvents;
import metaanalysis.dataeditor.models.AbstractEditorPanel;
import metaanalysis.events.models.IApplicationEvent;
import metaanalysis.models.tables.AbstractTable;

public class VariablesEditorPanel
extends AbstractEditorPanel {
    IVariablesStatisticReport reportController;

    public VariablesEditorPanel(IVariablesStatisticReport reportController, IApplicationManager applicationEventWorker, GuiChecker guiChecker) {
        super(applicationEventWorker, guiChecker);
        this.reportController = reportController;
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.reloadAll();
    }

    public void reloadAll() {
        this.reportController.refresh();
        this.removeAll();
        AbstractTable table = this.reportController.getTable();
        this.add((Component)table);
        this.add(table.getTableHeader(), "North");
        this.add((Component)table, "Center");
        if (this.reportController.getModelVariableStatistic().getVariableInstances().isEmpty()) {
            JPanel jp = new JPanel();
            jp.setLayout(new FlowLayout());
            jp.setBackground(StyleProvider.panelBackground);
            JLabel jLabel = new JLabel("No variables defined");
            jLabel.setAlignmentX(0.0f);
            jp.add(jLabel);
            this.add(jp);
        }
        this.validate();
    }

    public boolean readApplicationEvent(IApplicationEvent event) {
        if (event instanceof DataBaseEvents) {
            this.reloadAll();
            return true;
        }
        return false;
    }

    public String getBarTitle() {
        return this.reportController.getModelVariableStatistic().getName();
    }
}

